/*
 Platform.js <https://mths.be/platform>
 Copyright 2014-2018 Benjamin Tan <https://bnjmnt4n.now.sh/>
 Copyright 2011-2013 John-David Dalton
 Available under MIT license <https://mths.be/mit>
*/
(function () {
  var a = 'undefined' !== typeof window && 'undefined' !== typeof window.document ? window.document : {
  },
  d = 'undefined' !== typeof module && module.exports,
  b = 'undefined' !== typeof Element && 'ALLOW_KEYBOARD_INPUT' in Element,
  c = function () {
    for (var b, c = [
      'requestFullscreen exitFullscreen fullscreenElement fullscreenEnabled fullscreenchange fullscreenerror'.split(' '),
      'webkitRequestFullscreen webkitExitFullscreen webkitFullscreenElement webkitFullscreenEnabled webkitfullscreenchange webkitfullscreenerror'.split(' '),
      'webkitRequestFullScreen webkitCancelFullScreen webkitCurrentFullScreenElement webkitCancelFullScreen webkitfullscreenchange webkitfullscreenerror'.split(' '),
      'mozRequestFullScreen mozCancelFullScreen mozFullScreenElement mozFullScreenEnabled mozfullscreenchange mozfullscreenerror'.split(' '),
      'msRequestFullscreen msExitFullscreen msFullscreenElement msFullscreenEnabled MSFullscreenChange MSFullscreenError'.split(' ')
    ], d = 0, e = c.length, f = {
    }; d < e; d++) if ((b = c[d]) && b[1] in a) {
      for (d = 0; d < b.length; d++) f[c[0][d]] = b[d];
      return f
    }
    return !1
  }(),
  e = {
    change: c.fullscreenchange,
    error: c.fullscreenerror
  },
  f = {
    request: function (d) {
      var e = c.requestFullscreen;
      d = d || a.documentElement;
      if (/5\.1[.\d]* Safari/.test(navigator.userAgent)) d[e]();
       else d[e](b && Element.ALLOW_KEYBOARD_INPUT)
    },
    exit: function () {
      a[c.exitFullscreen]()
    },
    toggle: function (a) {
      this.isFullscreen ? this.exit()  : this.request(a)
    },
    onchange: function (a) {
      this.on('change', a)
    },
    onerror: function (a) {
      this.on('error', a)
    },
    on: function (b, c) {
      var d = e[b];
      d && a.addEventListener(d, c, !1)
    },
    off: function (b, c) {
      var d = e[b];
      d && a.removeEventListener(d, c, !1)
    },
    raw: c
  };
  c ? (Object.defineProperties(f, {
    isFullscreen: {
      get: function () {
        return !!a[c.fullscreenElement]
      }
    },
    element: {
      enumerable: !0,
      get: function () {
        return a[c.fullscreenElement]
      }
    },
    enabled: {
      enumerable: !0,
      get: function () {
        return !!a[c.fullscreenEnabled]
      }
    }
  }), d ? module.exports = f : window.screenfull = f)  : d ? module.exports = !1 : window.screenfull = !1
}) ();
(function () {
  function a(a) {
    a = String(a);
    return a.charAt(0).toUpperCase() + a.slice(1)
  }
  function d(a, b) {
    var d = - 1,
    e = a ? a.length : 0;
    if ('number' == typeof e && - 1 < e && e <= m) for (; ++d < e; ) b(a[d], d, a);
     else c(a, b)
  }
  function b(b) {
    b = String(b).replace(/^ +| +$/g, '');
    return /^(?:webOS|i(?:OS|P))/.test(b) ? b : a(b)
  }
  function c(a, b) {
    for (var c in a) t.call(a, c) && b(a[c], c, a)
  }
  function e(b) {
    return null == b ? a(b)  : D.call(b).slice(8, - 1)
  }
  function f(a, b) {
    var c = null != a ? typeof a[b] : 'number';
    return !/^(?:boolean|number|string|undefined)$/.test(c) && ('object' == c ? !!a[b] : !0)
  }
  function k(a) {
    return String(a).replace(/([ -])(?!$)/g, '$1?')
  }
  function r(a, b) {
    var c = null;
    d(a, function (d, e) {
      c = b(c, d, e, a)
    });
    return c
  }
  function q(a) {
    function d(c) {
      return r(c, function (c, d) {
        var e = d.pattern || k(d);
        !c && (c = RegExp('\\b' + e + ' *\\d+[.\\w_]*', 'i').exec(a) || RegExp('\\b' + e + ' *\\w+-[\\w]*', 'i').exec(a) || RegExp('\\b' + e + '(?:; *(?:[a-z]+[_-])?[a-z]+\\d+|[^ ();-]*)', 'i').exec(a)) && ((c = String(d.label && !RegExp(e, 'i').test(d.label) ? d.label : c).split('/')) [1] && !/[\d.]+/.test(c[0]) && (c[0] +=
        ' ' + c[1]), d = d.label || d, c = b(c[0].replace(RegExp(e, 'i'), d).replace(RegExp('; *(?:' + d + '[_-])?', 'i'), ' ').replace(RegExp('(' + d + ')[-_.]?(\\w)', 'i'), '$1 $2')));
        return c
      })
    }
    function l(b) {
      return r(b, function (b, c) {
        return b || (RegExp(c + '(?:-[\\d.]+/|(?: for [\\w-]+)?[ /-])([\\d.]+[^ ();/_-]*)', 'i').exec(a) || 0) [1] || null
      })
    }
    var g = p,
    m = a && 'object' == typeof a && 'String' != e(a);
    m && (g = a, a = null);
    var n = g.navigator || {
    },
    t = n.userAgent || '';
    a || (a = t);
    var C = m ? !!n.likeChrome : /\bChrome\b/.test(a) && !/internal|\n/i.test(D.toString()),
    F = m ? 'Object' : 'ScriptBridgingProxyObject',
    P = m ? 'Object' : 'Environment',
    E = m && g.java ? 'JavaPackage' : e(g.java),
    Q = m ? 'Object' : 'RuntimeObject';
    P = (E = /\bJava/.test(E) && g.java) && e(g.environment) == P;
    var T = E ? 'a' : 'α',
    L = E ? 'b' : 'β',
    y = g.document || {
    },
    R = g.operamini || g.opera,
    G = v.test(G = m && R ? R['[[Class]]'] : e(R)) ? G : R = null,
    h,
    U = a;
    m = [
    ];
    var V = null,
    S = a == t;
    t = S && R && 'function' == typeof R.version && R.version();
    var A = function (b) {
      return r(b, function (b, c) {
        return b || RegExp('\\b' + (c.pattern || k(c)) + '\\b', 'i').exec(a) && (c.label || c)
      })
    }([{
      label: 'EdgeHTML',
      pattern: 'Edge'
    },
    'Trident',
    {
      label: 'WebKit',
      pattern: 'AppleWebKit'
    },
    'iCab',
    'Presto',
    'NetFront',
    'Tasman',
    'KHTML',
    'Gecko']),
    u = function (b) {
      return r(b, function (b, c) {
        return b || RegExp('\\b' + (c.pattern || k(c)) + '\\b', 'i').exec(a) && (c.label || c)
      })
    }(['Adobe AIR',
    'Arora',
    'Avant Browser',
    'Breach',
    'Camino',
    'Electron',
    'Epiphany',
    'Fennec',
    'Flock',
    'Galeon',
    'GreenBrowser',
    'iCab',
    'Iceweasel',
    'K-Meleon',
    'Konqueror',
    'Lunascape',
    'Maxthon',
    {
      label: 'Microsoft Edge',
      pattern: 'Edge'
    },
    'Midori',
    'Nook Browser',
    'PaleMoon',
    'PhantomJS',
    'Raven',
    'Rekonq',
    'RockMelt',
    {
      label: 'Samsung Internet',
      pattern: 'SamsungBrowser'
    },
    'SeaMonkey',
    {
      label: 'Silk',
      pattern: '(?:Cloud9|Silk-Accelerated)'
    },
    'Sleipnir',
    'SlimBrowser',
    {
      label: 'SRWare Iron',
      pattern: 'Iron'
    },
    'Sunrise',
    'Swiftfox',
    'Waterfox',
    'WebPositive',
    'Opera Mini',
    {
      label: 'Opera Mini',
      pattern: 'OPiOS'
    },
    'Opera',
    {
      label: 'Opera',
      pattern: 'OPR'
    },
    'Chrome',
    {
      label: 'Chrome Mobile',
      pattern: '(?:CriOS|CrMo)'
    },
    {
      label: 'Firefox',
      pattern: '(?:Firefox|Minefield)'
    },
    {
      label: 'Firefox for iOS',
      pattern: 'FxiOS'
    },
    {
      label: 'IE',
      pattern: 'IEMobile'
    },
    {
      label: 'IE',
      pattern: 'MSIE'
    },
    'Safari']),
    B = d([{
      label: 'BlackBerry',
      pattern: 'BB10'
    },
    'BlackBerry',
    {
      label: 'Galaxy S',
      pattern: 'GT-I9000'
    },
    {
      label: 'Galaxy S2',
      pattern: 'GT-I9100'
    },
    {
      label: 'Galaxy S3',
      pattern: 'GT-I9300'
    },
    {
      label: 'Galaxy S4',
      pattern: 'GT-I9500'
    },
    {
      label: 'Galaxy S5',
      pattern: 'SM-G900'
    },
    {
      label: 'Galaxy S6',
      pattern: 'SM-G920'
    },
    {
      label: 'Galaxy S6 Edge',
      pattern: 'SM-G925'
    },
    {
      label: 'Galaxy S7',
      pattern: 'SM-G930'
    },
    {
      label: 'Galaxy S7 Edge',
      pattern: 'SM-G935'
    },
    'Google TV',
    'Lumia',
    'iPad',
    'iPod',
    'iPhone',
    'Kindle',
    {
      label: 'Kindle Fire',
      pattern: '(?:Cloud9|Silk-Accelerated)'
    },
    'Nexus',
    'Nook',
    'PlayBook',
    'PlayStation Vita',
    'PlayStation',
    'TouchPad',
    'Transformer',
    {
      label: 'Wii U',
      pattern: 'WiiU'
    },
    'Wii',
    'Xbox One',
    {
      label: 'Xbox 360',
      pattern: 'Xbox'
    },
    'Xoom']),
    M = function (b) {
      return r(b, function (b, c, d) {
        return b || (c[B] || c[/^[a-z]+(?: +[a-z]+\b)*/i.exec(B)] || RegExp('\\b' + k(d) + '(?:\\b|\\w*\\d)', 'i').exec(a)) && d
      })
    }({
      Apple: {
        iPad: 1,
        iPhone: 1,
        iPod: 1
      },
      Archos: {
      },
      Amazon: {
        Kindle: 1,
        'Kindle Fire': 1
      },
      Asus: {
        Transformer: 1
      },
      'Barnes & Noble': {
        Nook: 1
      },
      BlackBerry: {
        PlayBook: 1
      },
      Google: {
        'Google TV': 1,
        Nexus: 1
      },
      HP: {
        TouchPad: 1
      },
      HTC: {
      },
      LG: {
      },
      Microsoft: {
        Xbox: 1,
        'Xbox One': 1
      },
      Motorola: {
        Xoom: 1
      },
      Nintendo: {
        'Wii U': 1,
        Wii: 1
      },
      Nokia: {
        Lumia: 1
      },
      Samsung: {
        'Galaxy S': 1,
        'Galaxy S2': 1,
        'Galaxy S3': 1,
        'Galaxy S4': 1
      },
      Sony: {
        PlayStation: 1,
        'PlayStation Vita': 1
      }
    }),
    w = function (c) {
      return r(c, function (c, d) {
        var e = d.pattern || k(d);
        if (!c && (c = RegExp('\\b' + e + '(?:/[\\d.]+|[ \\w.]*)', 'i').exec(a))) {
          var g = c,
          t = d.label || d,
          m = {
            '10.0': '10',
            '6.4': '10 Technical Preview',
            '6.3': '8.1',
            '6.2': '8',
            '6.1': 'Server 2008 R2 / 7',
            '6.0': 'Server 2008 / Vista',
            '5.2': 'Server 2003 / XP 64-bit',
            '5.1': 'XP',
            '5.01': '2000 SP1',
            '5.0': '2000',
            '4.0': 'NT',
            '4.90': 'ME'
          };
          e && t && /^Win/i.test(g) && !/^Windows Phone /i.test(g) && (m = m[/[\d.]+$/.exec(g)]) && (g = 'Windows ' + m);
          g = String(g);
          e && t && (g = g.replace(RegExp(e, 'i'), t));
          c = g = b(g.replace(/ ce$/i, ' CE').replace(/\bhpw/i, 'web').replace(/\bMacintosh\b/, 'Mac OS').replace(/_PowerPC\b/i, ' OS').replace(/\b(OS X) [^ \d]+/i, '$1').replace(/\bMac (OS X)\b/, '$1').replace(/\/(\d)/, ' $1').replace(/_/g, '.').replace(/(?: BePC|[ .]*fc[ \d.]+)$/i, '').replace(/\bx86\.64\b/gi, 'x86_64').replace(/\b(Windows Phone) OS\b/, '$1').replace(/\b(Chrome OS \w+) [\d.]+\b/, '$1').split(' on ') [0])
        }
        return c
      })
    }(['Windows Phone',
    'Android',
    'CentOS',
    {
      label: 'Chrome OS',
      pattern: 'CrOS'
    },
    'Debian',
    'Fedora',
    'FreeBSD',
    'Gentoo',
    'Haiku',
    'Kubuntu',
    'Linux Mint',
    'OpenBSD',
    'Red Hat',
    'SuSE',
    'Ubuntu',
    'Xubuntu',
    'Cygwin',
    'Symbian OS',
    'hpwOS',
    'webOS ',
    'webOS',
    'Tablet OS',
    'Tizen',
    'Linux',
    'Mac OS X',
    'Macintosh',
    'Mac',
    'Windows 98;',
    'Windows ']);
    A && (A = [
      A
    ]);
    M && !B && (B = d([M]));
    if (h = /\bGoogle TV\b/.exec(B)) B = h[0];
    /\bSimulator\b/i.test(a) && (B = (B ? B + ' ' : '') + 'Simulator');
    'Opera Mini' == u && /\bOPiOS\b/.test(a) && m.push('running in Turbo/Uncompressed mode');
    'IE' == u && /\blike iPhone OS\b/.test(a) ? (h = q(a.replace(/like iPhone OS/, '')), M = h.manufacturer, B = h.product)  : /^iP/.test(B) ? (u || (u = 'Safari'), w = 'iOS' + ((h = / OS ([\d_]+)/i.exec(a)) ? ' ' + h[1].replace(/_/g, '.')  : ''))  : 'Konqueror' != u || /buntu/i.test(w) ? M && 'Google' != M && (/Chrome/.test(u) && !/\bMobile Safari\b/i.test(a) || /\bVita\b/.test(B)) || /\bAndroid\b/.test(w) && /^Chrome/.test(u) && /\bVersion\//i.test(a) ? (u = 'Android Browser', w = /\bAndroid\b/.test(w) ? w : 'Android')  : 'Silk' == u ? (/\bMobi/i.test(a) || (w = 'Android', m.unshift('desktop mode')), /Accelerated *= *true/i.test(a) && m.unshift('accelerated'))  : 'PaleMoon' == u && (h = /\bFirefox\/([\d.]+)\b/.exec(a)) ? m.push('identifying as Firefox ' + h[1])  : 'Firefox' == u && (h = /\b(Mobile|Tablet|TV)\b/i.exec(a)) ? (w || (w = 'Firefox OS'), B || (B = h[1]))  : !u || (h = !/\bMinefield\b/i.test(a) && /\b(?:Firefox|Safari)\b/.exec(u)) ? (u && !B && /[\/,]|^[^(]+?\)/.test(a.slice(a.indexOf(h + '/') + 8)) && (u = null), (h = B || M || w) && (B || M || /\b(?:Android|Symbian OS|Tablet OS|webOS)\b/.test(w)) && (u = /[a-z]+(?: Hat)?/i.exec(/\bAndroid\b/.test(w) ? w : h) + ' Browser'))  : 'Electron' == u && (h = (/\bChrome\/([\d.]+)\b/.exec(a) || 0) [1]) && m.push('Chromium ' + h)  : w = 'Kubuntu';
    t || (t = l(['(?:Cloud9|CriOS|CrMo|Edge|FxiOS|IEMobile|Iron|Opera ?Mini|OPiOS|OPR|Raven|SamsungBrowser|Silk(?!/[\\d.]+$))',
    'Version',
    k(u),
    '(?:Firefox|Minefield|NetFront)']));
    if (h = 'iCab' == A && 3 < parseFloat(t) && 'WebKit' || /\bOpera\b/.test(u) && (/\bOPR\b/.test(a) ? 'Blink' : 'Presto') || /\b(?:Midori|Nook|Safari)\b/i.test(a) && !/^(?:Trident|EdgeHTML)$/.test(A) && 'WebKit' || !A && /\bMSIE\b/i.test(a) && ('Mac OS' == w ? 'Tasman' : 'Trident') || 'WebKit' == A && /\bPlayStation\b(?! Vita\b)/i.test(u) && 'NetFront') A = [
      h
    ];
    'IE' == u && (h = (/; *(?:XBLWP|ZuneWP)(\d+)/i.exec(a) || 0) [1]) ? (u += ' Mobile', w = 'Windows Phone ' + (/\+$/.test(h) ? h : h + '.x'), m.unshift('desktop mode'))  : /\bWPDesktop\b/i.test(a) ? (u = 'IE Mobile', w = 'Windows Phone 8.x', m.unshift('desktop mode'), t || (t = (/\brv:([\d.]+)/.exec(a) || 0) [1]))  : 'IE' != u && 'Trident' == A && (h = /\brv:([\d.]+)/.exec(a)) && (u && m.push('identifying as ' + u + (t ? ' ' + t : '')), u = 'IE', t = h[1]);
    if (S) {
      if (f(g, 'global')) if (E && (h = E.lang.System, U = h.getProperty('os.arch'), w = w || h.getProperty('os.name') + ' ' + h.getProperty('os.version')), P) {
        try {
          t = g.require('ringo/engine').version.join('.'),
          u = 'RingoJS'
        } catch (X) {
          (h = g.system) && h.global.system == g.system && (u = 'Narwhal', w || (w = h[0].os || null))
        }
        u || (u = 'Rhino')
      } else 'object' == typeof g.process && !g.process.browser && (h = g.process) && ('object' == typeof h.versions && ('string' == typeof h.versions.electron ? (m.push('Node ' + h.versions.node), u = 'Electron', t = h.versions.electron)  : 'string' == typeof h.versions.nw && (m.push('Chromium ' + t, 'Node ' + h.versions.node), u = 'NW.js', t = h.versions.nw)), u || (u = 'Node.js', U = h.arch, w = h.platform, t = (t = /[\d.]+/.exec(h.version)) ? t[0] : null));
       else e(h = g.runtime) == F ? (u = 'Adobe AIR', w = h.flash.system.Capabilities.os)  : e(h = g.phantom) == Q ? (u = 'PhantomJS', t = (h = h.version || null) && h.major + '.' + h.minor +
      '.' + h.patch)  : 'number' == typeof y.documentMode && (h = /\bTrident\/(\d+)/i.exec(a)) ? (t = [
        t,
        y.documentMode
      ], (h = + h[1] + 4) != t[1] && (m.push('IE ' + t[1] + ' mode'), A && (A[1] = ''), t[1] = h), t = 'IE' == u ? String(t[1].toFixed(1))  : t[0])  : 'number' == typeof y.documentMode && /^(?:Chrome|Firefox)\b/.test(u) && (m.push('masking as ' + u + ' ' + t), u = 'IE', t = '11.0', A = [
        'Trident'
      ], w = 'Windows');
      w = w && b(w)
    }
    t && (h = /(?:[ab]|dp|pre|[ab]\d+pre)(?:\d+\+?)?$/i.exec(t) || /(?:alpha|beta)(?: ?\d)?/i.exec(a + ';' + (S && n.appMinorVersion)) || /\bMinefield\b/i.test(a) && 'a') && (V = /b/i.test(h) ? 'beta' : 'alpha', t = t.replace(RegExp(h + '\\+?$'), '') + ('beta' == V ? L : T) + (/\d+\+?/.exec(h) || ''));
    if ('Fennec' == u || 'Firefox' == u && /\b(?:Android|Firefox OS)\b/.test(w)) u = 'Firefox Mobile';
     else if ('Maxthon' == u && t) t = t.replace(/\.[\d.]+/, '.x');
     else if (/\bXbox\b/i.test(B)) 'Xbox 360' == B && (w = null),
    'Xbox 360' == B && /\bIEMobile\b/.test(a) && m.unshift('mobile mode');
     else if (!/^(?:Chrome|IE|Opera)$/.test(u) && (!u || B || /Browser|Mobi/.test(u)) || 'Windows CE' != w && !/Mobi/i.test(a)) if ('IE' == u && S) try {
      null === g.external && m.unshift('platform preview')
    } catch (X) {
      m.unshift('embedded')
    } else (/\bBlackBerry\b/.test(B) || /\bBB10\b/.test(a)) && (h = (RegExp(B.replace(/ +/g, ' *') + '/([.\\d]+)', 'i').exec(a) || 0) [1] || t) ? (h = [
      h,
      /BB10/.test(a)
    ], w = (h[1] ? (B = null, M = 'BlackBerry')  : 'Device Software') + ' ' + h[0], t = null)  : this != c && 'Wii' != B && (S && R || /Opera/.test(u) && /\b(?:MSIE|Firefox)\b/i.test(a) || 'Firefox' == u && /\bOS X (?:\d+\.){2,}/.test(w) || 'IE' == u && (w && !/^Win/.test(w) && 5.5 < t || /\bWindows XP\b/.test(w) && 8 < t || 8 == t && !/\bTrident\b/.test(a))) && !v.test(h = q.call(c, a.replace(v, '') + ';')) && h.name && (h = 'ing as ' + h.name + ((h = h.version) ? ' ' + h : ''), v.test(u) ? (/\bIE\b/.test(h) && 'Mac OS' == w && (w = null), h = 'identify' + h)  : (h = 'mask' + h, u = G ? b(G.replace(/([a-z])([A-Z])/g, '$1 $2'))  : 'Opera', /\bIE\b/.test(h) && (w = null), S || (t = null)), A = [
      'Presto'
    ], m.push(h));
     else u += ' Mobile';
    if (h = (/\bAppleWebKit\/([\d.]+\+?)/i.exec(a) || 0) [1]) {
      h = [
        parseFloat(h.replace(/\.(\d)$/, '.0$1')),
        h
      ];
      if ('Safari' == u && '+' == h[1].slice( - 1)) u = 'WebKit Nightly',
      V = 'alpha',
      t = h[1].slice(0, - 1);
       else if (t == h[1] || t == (h[2] = (/\bSafari\/([\d.]+\+?)/i.exec(a) || 0) [1])) t = null;
      h[1] = (/\bChrome\/([\d.]+)/i.exec(a) || 0) [1];
      537.36 == h[0] && 537.36 == h[2] && 28 <= parseFloat(h[1]) && 'WebKit' == A && (A = [
        'Blink'
      ]);
      S && (C || h[1]) ? (A && (A[1] = 'like Chrome'), h = h[1] || (h = h[0], 530 > h ? 1 : 532 > h ? 2 : 532.05 > h ? 3 : 533 > h ? 4 : 534.03 > h ? 5 : 534.07 > h ? 6 : 534.1 > h ? 7 : 534.13 > h ? 8 : 534.16 > h ? 9 : 534.24 > h ? 10 : 534.3 > h ? 11 : 535.01 > h ? 12 : 535.02 > h ? '13+' : 535.07 > h ? 15 : 535.11 > h ? 16 : 535.19 > h ? 17 : 536.05 > h ? 18 : 536.1 > h ? 19 : 537.01 > h ? 20 : 537.11 > h ? '21+' : 537.13 > h ? 23 : 537.18 > h ? 24 : 537.24 > h ? 25 : 537.36 > h ? 26 : 'Blink' !=
      A ? '27' : '28'))  : (A && (A[1] = 'like Safari'), h = (h = h[0], 400 > h ? 1 : 500 > h ? 2 : 526 > h ? 3 : 533 > h ? 4 : 534 > h ? '4+' : 535 > h ? 5 : 537 > h ? 6 : 538 > h ? 7 : 601 > h ? 8 : '8'));
      A && (A[1] += ' ' + (h += 'number' == typeof h ? '.x' : /[.+]/.test(h) ? '' : '+'));
      'Safari' == u && (!t || 45 < parseInt(t)) && (t = h)
    }
    'Opera' == u && (h = /\bzbov|zvav$/.exec(w)) ? (u += ' ', m.unshift('desktop mode'), 'zvav' == h ? (u += 'Mini', t = null)  : u += 'Mobile', w = w.replace(RegExp(' *' + h + '$'), ''))  : 'Safari' == u && /\bChrome\b/.exec(A && A[1]) && (m.unshift('desktop mode'), u = 'Chrome Mobile', t = null, /\bOS X\b/.test(w) ? (M = 'Apple', w = 'iOS 4.3+')  : w = null);
    t && 0 == t.indexOf(h = /[\d.]+$/.exec(w)) && - 1 < a.indexOf('/' + h + '-') && (w = String(w.replace(h, '')).replace(/^ +| +$/g, ''));
    A && !/\b(?:Avant|Nook)\b/.test(u) && (/Browser|Lunascape|Maxthon/.test(u) || 'Safari' != u && /^iOS/.test(w) && /\bSafari\b/.test(A[1]) || /^(?:Adobe|Arora|Breach|Midori|Opera|Phantom|Rekonq|Rock|Samsung Internet|Sleipnir|Web)/.test(u) && A[1]) && (h = A[A.length - 1]) && m.push(h);
    m.length && (m = [
      '(' + m.join('; ') + ')'
    ]);
    M && B && 0 > B.indexOf(M) && m.push('on ' + M);
    B && m.push((/^on /.test(m[m.length -
    1]) ? '' : 'on ') + B);
    if (w) {
      var W = (h = / ([\d.+]+)$/.exec(w)) && '/' == w.charAt(w.length - h[0].length - 1);
      w = {
        architecture: 32,
        family: h && !W ? w.replace(h[0], '')  : w,
        version: h ? h[1] : null,
        toString: function () {
          var a = this.version;
          return this.family + (a && !W ? ' ' + a : '') + (64 == this.architecture ? ' 64-bit' : '')
        }
      }
    }(h = /\b(?:AMD|IA|Win|WOW|x86_|x)64\b/i.exec(U)) && !/\bi686\b/i.test(U) ? (w && (w.architecture = 64, w.family = w.family.replace(RegExp(' *' + h), '')), u && (/\bWOW64\b/i.test(a) || S && /\w(?:86|32)$/.test(n.cpuClass || n.platform) && !/\bWin64; x64\b/i.test(a)) && m.unshift('32-bit'))  : w && /^OS X/.test(w.family) && 'Chrome' == u && 39 <= parseFloat(t) && (w.architecture = 64);
    a || (a = null);
    g = {
    };
    g.description = a;
    g.layout = A && A[0];
    g.manufacturer = M;
    g.name = u;
    g.prerelease = V;
    g.product = B;
    g.ua = a;
    g.version = u && t;
    g.os = w || {
      architecture: null,
      family: null,
      version: null,
      toString: function () {
        return 'null'
      }
    };
    g.parse = q;
    g.toString = function () {
      return this.description || ''
    };
    g.version && m.unshift(t);
    g.name && m.unshift(u);
    w && u && (w != String(w).split(' ') [0] || w != u.split(' ') [0] && !B) && m.push(B ? '(' + w + ')' : 'on ' +
    w);
    m.length && (g.description = m.join(' '));
    return g
  }
  var n = {
    'function': !0,
    object: !0
  },
  p = n[typeof window] && window || this,
  g = n[typeof exports] && exports;
  n = n[typeof module] && module && !module.nodeType && module;
  var l = g && n && 'object' == typeof global && global;
  !l || l.global !== l && l.window !== l && l.self !== l || (p = l);
  var m = Math.pow(2, 53) - 1,
  v = /\bOpera/;
  l = Object.prototype;
  var t = l.hasOwnProperty,
  D = l.toString,
  C = q();
  'function' == typeof define && 'object' == typeof define.amd && define.amd ? (p.platform = C, define(function () {
    return C
  }))  : g && n ? c(C, function (a, b) {
    g[b] = a
  })  : p.platform = C
}).call(this);
function buildIOSMeta() {
  for (var a = [
    {
      name: 'viewport',
      content: 'width=device-width, height=device-height, initial-scale=1, minimum-scale=1, maximum-scale=1, user-scalable=no'
    },
    {
      name: 'apple-mobile-web-app-capable',
      content: 'yes'
    },
    {
      name: 'apple-mobile-web-app-status-bar-style',
      content: 'black'
    }
  ], d = 0; d < a.length; d++) {
    var b = document.createElement('meta');
    b.name = a[d].name;
    b.content = a[d].content;
    var c = window.document.head.querySelector('meta[name="' + b.name + '"]');
    c && c.parentNode.removeChild(c);
    window.document.head.appendChild(b)
  }
}
function hideIOSFullscreenPanel() {
  jQuery('.xxx-ios-fullscreen-message').css('display', 'none');
  jQuery('.xxx-ios-fullscreen-scroll').css('display', 'none');
  jQuery('.xxx-game-iframe-full').removeClass('xxx-game-iframe-iphone-se')
}
function buildIOSFullscreenPanel() {
  jQuery('body').append('<div class="xxx-ios-fullscreen-message"><div class="xxx-ios-fullscreen-swipe"></div></div><div class="xxx-ios-fullscreen-scroll"></div>')
}
function showIOSFullscreenPanel() {
  jQuery('.xxx-ios-fullscreen-message').css('display', 'block');
  jQuery('.xxx-ios-fullscreen-scroll').css('display', 'block')
}
function __iosResize() {
  window.scrollTo(0, 0);
  if ('iPhone' === platform.product) switch (window.devicePixelRatio) {
    case 2:
      switch (window.innerWidth) {
        case 568:
          320 !== window.innerHeight && jQuery('.xxx-game-iframe-full').addClass('xxx-game-iframe-iphone-se');
          break;
        case 667:
          375 === window.innerHeight ? hideIOSFullscreenPanel()  : showIOSFullscreenPanel();
          break;
        default:
          hideIOSFullscreenPanel()
      }
      break;
    case 3:
      switch (window.innerWidth) {
        case 736:
          414 === window.innerHeight ? hideIOSFullscreenPanel()  : showIOSFullscreenPanel();
          break;
        case 724:
          375 === window.innerHeight ? hideIOSFullscreenPanel()  : showIOSFullscreenPanel();
          break;
        default:
          hideIOSFullscreenPanel()
      }
      break;
    default:
      hideIOSFullscreenPanel()
  }
}
function iosResize() {
  __iosResize();
  setTimeout(function () {
    __iosResize()
  }, 500)
}
function iosInIframe() {
  try {
    return window.self !== window.top
  } catch (a) {
    return !0
  }
}
$(document).ready(function () {
  platform && 'iPhone' === platform.product && !iosInIframe() && (buildIOSFullscreenPanel(), buildIOSMeta())
});
jQuery(window).resize(function () {
  platform && 'iPhone' === platform.product && !iosInIframe() && iosResize()
});
var s_iScaleFactor = 1,
s_bIsIphone = !1,
s_iOffsetX,
s_iOffsetY;
(function (a) {
  (jQuery.browser = jQuery.browser || {
  }).mobile = /android|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(ad|hone|od)|iris|kindle|lge |maemo|midp|mmp|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|symbian|tablet|treo|up\.(browser|link)|vodafone|wap|webos|windows (ce|phone)|xda|xiino/i.test(a) || /1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|e\-|e\/|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(di|rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|xda(\-|2|g)|yas\-|your|zeto|zte\-/i.test(a.substr(0, 4))
}) (navigator.userAgent || navigator.vendor || window.opera);
$(window).resize(function () {
  sizeHandler()
});
function trace(a) {
  console.log(a)
}
function getSize(a) {
  var d = a.toLowerCase(),
  b = window.document,
  c = b.documentElement;
  if (void 0 === window['inner' + a]) a = c['client' + a];
   else if (window['inner' + a] != c['client' + a]) {
    var e = b.createElement('body');
    e.id = 'vpw-test-b';
    e.style.cssText = 'overflow:scroll';
    var f = b.createElement('div');
    f.id = 'vpw-test-d';
    f.style.cssText = 'position:absolute;top:-1000px';
    f.innerHTML = '<style>@media(' + d + ':' + c['client' + a] + 'px){body#vpw-test-b div#vpw-test-d{' + d + ':7px!important}}</style>';
    e.appendChild(f);
    c.insertBefore(e, b.head);
    a = 7 == f['offset' + a] ? c['client' + a] : window['inner' + a];
    c.removeChild(e)
  } else a = window['inner' + a];
  return a
}
window.addEventListener('orientationchange', onOrientationChange);
function onOrientationChange() {
  window.matchMedia('(orientation: portrait)').matches && sizeHandler();
  window.matchMedia('(orientation: landscape)').matches && sizeHandler()
}
function isChrome() {
  return /Chrome/.test(navigator.userAgent) && /Google Inc/.test(navigator.vendor)
}
function isIOS() {
  var a = 'iPad Simulator;iPhone Simulator;iPod Simulator;iPad;iPhone;iPod'.split(';');
  for ( - 1 !== navigator.userAgent.toLowerCase().indexOf('iphone') && (s_bIsIphone = !0); a.length; ) if (navigator.platform === a.pop()) return !0;
  return s_bIsIphone = !1
}
function getIOSWindowHeight() {
  return document.documentElement.clientWidth / window.innerWidth * window.innerHeight
}
function getHeightOfIOSToolbars() {
  var a = (0 === window.orientation ? screen.height : screen.width) - getIOSWindowHeight();
  return 1 < a ? a : 0
}
function sizeHandler() {
  window.scrollTo(0, 1);
  if ($('#canvas')) {
    var a = navigator.userAgent.match(/(iPad|iPhone|iPod)/g) ? getIOSWindowHeight()  : getSize('Height');
    var d = getSize('Width');
    _checkOrientation(d, a);
    var b = Math.min(a / CANVAS_HEIGHT, d / CANVAS_WIDTH),
    c = CANVAS_WIDTH * b;
    b *= CANVAS_HEIGHT;
    if (b < a) {
      var e = a - b;
      b += e;
      c += CANVAS_WIDTH / CANVAS_HEIGHT * e
    } else c < d && (e = d - c, c += e, b += CANVAS_HEIGHT / CANVAS_WIDTH * e);
    e = a / 2 - b / 2;
    var f = d / 2 - c / 2,
    k = CANVAS_WIDTH / c;
    if (f * k < - EDGEBOARD_X || e * k < - EDGEBOARD_Y) b = Math.min(a / (CANVAS_HEIGHT - 2 * EDGEBOARD_Y), d / (CANVAS_WIDTH - 2 * EDGEBOARD_X)),
    c = CANVAS_WIDTH * b,
    b *= CANVAS_HEIGHT,
    e = (a - b) / 2,
    f = (d - c) / 2,
    k = CANVAS_WIDTH / c;
    s_iOffsetX = - 1 * f * k;
    s_iOffsetY = - 1 * e * k;
    0 <= e && (s_iOffsetY = 0);
    0 <= f && (s_iOffsetX = 0);
    null !== s_oInterface && s_oInterface.refreshButtonPos(s_iOffsetX, s_iOffsetY);
    null !== s_oMenu && s_oMenu.refreshButtonPos(s_iOffsetX, s_iOffsetY);
    s_iScaleFactor = Math.min(c / CANVAS_WIDTH, b / CANVAS_HEIGHT);
    s_bIsIphone ? (canvas = document.getElementById('canvas'), s_oStage.canvas.width = 2 * c, s_oStage.canvas.height = 2 * b, canvas.style.width = c + 'px', canvas.style.height = b + 'px', s_iScaleFactor = 2 * Math.min(c / CANVAS_WIDTH, b / CANVAS_HEIGHT), s_oStage.scaleX = s_oStage.scaleY = s_iScaleFactor)  : s_bMobile || isChrome() ? ($('#canvas').css('width', c + 'px'), $('#canvas').css('height', b + 'px'))  : (s_oStage.canvas.width = c, s_oStage.canvas.height = b, s_oStage.scaleX = s_oStage.scaleY = s_iScaleFactor);
    0 > e ? $('#canvas').css('top', e + 'px')  : $('#canvas').css('top', '0px');
    $('#canvas').css('left', f + 'px');
    fullscreenHandler()
  }
}
function _checkOrientation(a, d) {
  s_bMobile && ENABLE_CHECK_ORIENTATION && (a > d ? 'landscape' === $('.orientation-msg-container').attr('data-orientation') ? ($('.orientation-msg-container').css('display', 'none'), s_oMain.startUpdate())  : ($('.orientation-msg-container').css('display', 'block'), s_oMain.stopUpdate())  : 'portrait' === $('.orientation-msg-container').attr('data-orientation') ? ($('.orientation-msg-container').css('display', 'none'), s_oMain.startUpdate())  : ($('.orientation-msg-container').css('display', 'block'), s_oMain.stopUpdate()))
}
function createBitmap(a, d, b) {
  var c = new createjs.Bitmap(a),
  e = new createjs.Shape;
  d && b ? e.graphics.beginFill('#fff').drawRect(0, 0, d, b)  : e.graphics.beginFill('#ff0').drawRect(0, 0, a.width, a.height);
  c.hitArea = e;
  return c
}
function createSprite(a, d, b, c, e, f) {
  a = null !== d ? new createjs.Sprite(a, d)  : new createjs.Sprite(a);
  d = new createjs.Shape;
  d.graphics.beginFill('#000000').drawRect( - b, - c, e, f);
  a.hitArea = d;
  return a
}
function randomFloatBetween(a, d, b) {
  'undefined' === typeof b && (b = 2);
  return parseFloat(Math.min(a + Math.random() * (d - a), d).toFixed(b))
}
function shuffle(a) {
  for (var d = a.length, b, c; 0 !== d; ) c = Math.floor(Math.random() * d),
  --d,
  b = a[d],
  a[d] = a[c],
  a[c] = b;
  return a
}
function formatTime(a) {
  a /= 1000;
  var d = Math.floor(a / 60);
  a = parseFloat(a - 60 * d).toFixed(1);
  var b = '';
  b = 10 > d ? b + ('0' + d + ':')  : b + (d + ':');
  return 10 > a ? b + ('0' + a)  : b + a
}
Array.prototype.sortOn = function () {
  var a = this.slice();
  if (!arguments.length) return a.sort();
  var d = Array.prototype.slice.call(arguments);
  return a.sort(function (a, c) {
    for (var b = d.slice(), f = b.shift(); a[f] == c[f] && b.length; ) f = b.shift();
    return a[f] == c[f] ? 0 : a[f] > c[f] ? 1 : - 1
  })
};
function roundDecimal(a, d) {
  var b = Math.pow(10, d);
  return Math.round(b * a) / b
}
function tweenVectors(a, d, b, c) {
  c.set(a.getX() + b * (d.getX() - a.getX()), a.getY() + b * (d.getY() - a.getY()));
  return c
}
function NoClickDelay(a) {
  this.element = a;
  window.Touch && this.element.addEventListener('touchstart', this, !1)
}
NoClickDelay.prototype = {
  handleEvent: function (a) {
    switch (a.type) {
      case 'touchstart':
        this.onTouchStart(a);
        break;
      case 'touchmove':
        this.onTouchMove(a);
        break;
      case 'touchend':
        this.onTouchEnd(a)
    }
  },
  onTouchStart: function (a) {
    a.preventDefault();
    this.moved = !1;
    this.element.addEventListener('touchmove', this, !1);
    this.element.addEventListener('touchend', this, !1)
  },
  onTouchMove: function (a) {
    this.moved = !0
  },
  onTouchEnd: function (a) {
    this.element.removeEventListener('touchmove', this, !1);
    this.element.removeEventListener('touchend', this, !1);
    if (!this.moved) {
      a = document.elementFromPoint(a.changedTouches[0].clientX, a.changedTouches[0].clientY);
      3 === a.nodeType && (a = a.parentNode);
      var d = document.createEvent('MouseEvents');
      d.initEvent('click', !0, !0);
      a.dispatchEvent(d)
    }
  }
};
function playSound(a, d, b) {
  return !1 === DISABLE_SOUND_MOBILE || !1 === s_bMobile ? (s_aSounds[a].play(), s_aSounds[a].volume(d), s_aSounds[a].loop(b), s_aSounds[a])  : null
}
function stopSound(a) {
  !1 !== DISABLE_SOUND_MOBILE && !1 !== s_bMobile || s_aSounds[a].stop()
}
function setVolume(a, d) {
  !1 !== DISABLE_SOUND_MOBILE && !1 !== s_bMobile || s_aSounds[a].volume(d)
}
function setMute(a, d) {
  !1 !== DISABLE_SOUND_MOBILE && !1 !== s_bMobile || s_aSounds[a].mute(d)
}
function ctlArcadeResume() {
  null !== s_oMain && s_oMain.startUpdate()
}
function ctlArcadePause() {
  null !== s_oMain && s_oMain.stopUpdate()
}
function getParamValue(a) {
  for (var d = window.location.search.substring(1).split('&'), b = 0; b < d.length; b++) {
    var c = d[b].split('=');
    if (c[0] == a) return c[1]
  }
}
function fullscreenHandler() {
  ENABLE_FULLSCREEN && !1 !== screenfull.enabled && (s_bFullscreen = screen.height < window.innerHeight + 3 && screen.height > window.innerHeight - 3 ? !0 : !1, null !== s_oInterface && s_oInterface.resetFullscreenBut(), null !== s_oMenu && s_oMenu.resetFullscreenBut())
}
if (screenfull.enabled) screenfull.on('change', function () {
  s_bFullscreen = screenfull.isFullscreen;
  null !== s_oInterface && s_oInterface.resetFullscreenBut();
  null !== s_oMenu && s_oMenu.resetFullscreenBut()
});
function CSpriteLibrary() {
  var a,
  d,
  b,
  c,
  e,
  f;
  this.init = function (k, r, q) {
    b = d = 0;
    c = k;
    e = r;
    f = q;
    a = {
    }
  };
  this.addSprite = function (b, c) {
    a.hasOwnProperty(b) || (a[b] = {
      szPath: c,
      oSprite: new Image
    }, d++)
  };
  this.getSprite = function (b) {
    return a.hasOwnProperty(b) ? a[b].oSprite : null
  };
  this._onSpritesLoaded = function () {
    e.call(f)
  };
  this._onSpriteLoaded = function () {
    c.call(f);
    ++b === d && this._onSpritesLoaded()
  };
  this.loadSprites = function () {
    for (var b in a) a[b].oSprite.oSpriteLibrary = this,
    a[b].oSprite.onload = function () {
      this.oSpriteLibrary._onSpriteLoaded()
    },
    a[b].oSprite.src = a[b].szPath
  };
  this.getNumSprites = function () {
    return d
  }
}
var CANVAS_WIDTH = 1700,
CANVAS_HEIGHT = 768,
EDGEBOARD_X = 338,
EDGEBOARD_Y = 0,
FPS_TIME = 1000 / 24,
DISABLE_SOUND_MOBILE = !1,
FONT_GAME_1 = 'arialbold',
FONT_GAME_2 = 'Digital-7',
STATE_LOADING = 0,
STATE_MENU = 1,
STATE_HELP = 1,
STATE_GAME = 3,
STATE_GAME_WAITING_FOR_BET = 0,
STATE_GAME_DEALING = 1,
STATE_GAME_SHOW_WINNER = 2,
STATE_CARD_DEALING = 0,
STATE_CARD_REMOVING = 1,
ON_MOUSE_DOWN = 0,
ON_MOUSE_UP = 1,
ON_MOUSE_OVER = 2,
ON_MOUSE_OUT = 3,
ON_DRAG_START = 4,
ON_DRAG_END = 5,
ASSIGN_FICHES = 'ASSIGN_FICHES',
END_HAND = 'END_HAND',
ON_CARD_SHOWN = 'ON_CARD_SHOWN',
ON_CARD_ANIMATION_ENDING = 'ON_CARD_ANIMATION_ENDING',
ON_CARD_TO_REMOVE = 'ON_CARD_TO_REMOVE',
NUM_FICHES = 6,
CARD_WIDTH = 66,
CARD_HEIGHT = 102,
MIN_BET,
MAX_BET,
TOTAL_MONEY,
FICHE_WIDTH,
WIN_OCCURRENCE,
BET_OCCURRENCE,
TIME_FICHES_MOV = 600,
TIME_CARD_DEALING = 250,
TIME_CARD_REMOVE = 1000,
TIME_SHOW_FINAL_CARDS = 4000,
TIME_END_HAND,
BET_TIME = 10000,
AD_SHOW_COUNTER,
NUM_DECKS = 4,
BET_TIE = 0,
BET_BANKER = 1,
BET_PLAYER = 2,
WIN_TIE = 0,
WIN_DEALER = 1,
WIN_PLAYER = 2,
POS_BET = [
],
MULTIPLIERS = [
],
ENABLE_FULLSCREEN,
ENABLE_CHECK_ORIENTATION,
SHOW_CREDITS,
TEXT_BET = [
  'TIE',
  'BANKER',
  'PLAYER'
],
TEXT_WIN = 'WIN',
TEXT_SHOW_WIN = [
  'TIE - PAYS 8 TO 1',
  TEXT_BET[1],
  TEXT_BET[2]
],
TEXT_NO_WIN = 'NO WIN',
TEXT_PLAY = 'PLAY',
TEXT_CLEAR = 'CLEAR',
TEXT_REBET = 'REBET',
TEXT_DEAL = 'DEAL',
TEXT_MIN_BET = 'MIN BET',
TEXT_MAX_BET = 'MAX BET',
TEXT_NO = 'NO',
TEXT_YES = 'YES',
TEXT_RECHARGE = 'RECHARGE',
TEXT_EXIT = 'EXIT',
TEXT_MONEY = 'MONEY',
TEXT_CURRENCY = '$',
TEXT_CREDITS_DEVELOPED = 'DEVELOPED BY',
TEXT_PRELOADER_CONTINUE = 'START',
TEXT_DISPLAY_MSG_WAITING_BET = 'WAITING FOR YOUR BET',
TEXT_DISPLAY_MSG_PLAYER_LOSE = 'PLAYER LOSES THIS HAND!',
TEXT_DISPLAY_MSG_PLAYER_WIN = 'PLAYER WINS',
TEXT_DISPLAY_TIE = 'THIS HAND IS A TIE!',
TEXT_DISPLAY_MSG_DEALING = 'DEALING...',
TEXT_NO_MONEY = 'YOU DON\'T HAVE ENOUGH MONEY!!!',
TEXT_HAND_WON = 'HAND WON BY',
TEXT_ERROR_MIN_BET = 'YOUR BET IS LOWER THAN MINIMUM BET!!',
TEXT_SHARE_IMAGE = '200x200.jpg',
TEXT_SHARE_TITLE = 'Congratulations!',
TEXT_SHARE_MSG1 = 'You collected <strong>',
TEXT_SHARE_MSG2 = ' points</strong>!<br><br>Share your score with your friends!',
TEXT_SHARE_SHARE1 = 'My score is ',
TEXT_SHARE_SHARE2 = ' points! Can you do better?';
function CPreloader() {
  var a,
  d,
  b,
  c,
  e,
  f,
  k,
  r,
  q,
  n;
  this._init = function () {
    s_oSpriteLibrary.init(this._onImagesLoaded, this._onAllImagesLoaded, this);
    s_oSpriteLibrary.addSprite('progress_bar', './sprites/progress_bar.png');
    s_oSpriteLibrary.addSprite('200x200', './sprites/200x200.jpg');
    s_oSpriteLibrary.addSprite('but_start', './sprites/but_start.png');
    s_oSpriteLibrary.loadSprites();
    n = new createjs.Container;
    s_oStage.addChild(n)
  };
  this.unload = function () {
    n.removeAllChildren();
    q.unload()
  };
  this._onImagesLoaded = function () {
  };
  this._onAllImagesLoaded = function () {
    this.attachSprites();
    s_oMain.preloaderReady()
  };
  this.attachSprites = function () {
    var p = new createjs.Shape;
    p.graphics.beginFill('black').drawRect(0, 0, CANVAS_WIDTH, CANVAS_HEIGHT);
    n.addChild(p);
    p = s_oSpriteLibrary.getSprite('200x200');
    k = createBitmap(p);
    k.regX = 0.5 * p.width;
    k.regY = 0.5 * p.height;
    k.x = CANVAS_WIDTH / 2;
    k.y = CANVAS_HEIGHT / 2 - 180;
    n.addChild(k);
    r = new createjs.Shape;
    r.graphics.beginFill('rgba(0,0,0,0.01)').drawRoundRect(k.x - 100, k.y - 100, 200, 200, 10);
    n.addChild(r);
    k.mask = r;
    p = s_oSpriteLibrary.getSprite('progress_bar');
    c = createBitmap(p);
    c.x = CANVAS_WIDTH / 2 - p.width / 2;
    c.y = CANVAS_HEIGHT / 2 + 50;
    n.addChild(c);
    a = p.width;
    d = p.height;
    e = new createjs.Shape;
    e.graphics.beginFill('rgba(0,0,0,0.01)').drawRect(c.x, c.y, 1, d);
    n.addChild(e);
    c.mask = e;
    b = new createjs.Text('', '30px ' + FONT_GAME_1, '#fff');
    b.x = CANVAS_WIDTH / 2;
    b.y = CANVAS_HEIGHT / 2 + 100;
    b.textBaseline = 'alphabetic';
    b.textAlign = 'center';
    n.addChild(b);
    p = s_oSpriteLibrary.getSprite('but_start');
    q = new CTextButton(CANVAS_WIDTH / 2, CANVAS_HEIGHT / 2, p, TEXT_PRELOADER_CONTINUE, 'Arial', '#000', 'bold 40', n);
    q.addEventListener(ON_MOUSE_UP, this._onButStartRelease, this);
    q.setVisible(!1);
    f = new createjs.Shape;
    f.graphics.beginFill('black').drawRect(0, 0, CANVAS_WIDTH, CANVAS_HEIGHT);
    n.addChild(f);
    createjs.Tween.get(f).to({
      alpha: 0
    }, 500).call(function () {
      createjs.Tween.removeTweens(f);
      n.removeChild(f)
    })
  };
  this._onButStartRelease = function () {
    s_oMain._onRemovePreloader()
  };
  this.refreshLoader = function (f) {
    b.text = f + '%';
    100 === f && (q.setVisible(!0), b.visible = !1, c.visible = !1);
    e.graphics.clear();
    f = Math.floor(f * a / 100);
    e.graphics.beginFill('rgba(0,0,0,0.01)').drawRect(c.x, c.y, f, d)
  };
  this._init()
}
function CMain(a) {
  var d,
  b = 0,
  c = 0,
  e = STATE_LOADING,
  f,
  k;
  this.initContainer = function () {
    var a = document.getElementById('canvas');
    s_oStage = new createjs.Stage(a);
    createjs.Touch.enable(s_oStage);
    s_bMobile = jQuery.browser.mobile;
    !1 === s_bMobile && s_oStage.enableMouseOver(20);
    s_iPrevTime = (new Date).getTime();
    createjs.Ticker.setFPS(30);
    createjs.Ticker.addEventListener('tick', this._update);
    navigator.userAgent.match(/Windows Phone/i) && (DISABLE_SOUND_MOBILE = !0);
    s_oSpriteLibrary = new CSpriteLibrary;
    seekAndDestroy() ? f = new CPreloader : alert(1);
    s_oGameSettings = new CGameSettings;
    d = !0
  };
  this.preloaderReady = function () {
    this._loadImages();
    !1 !== DISABLE_SOUND_MOBILE && !1 !== s_bMobile || this._initSounds()
  };
  this.soundLoaded = function () {
    b++;
    f.refreshLoader(Math.floor(b / c * 100))
  };
  this._initSounds = function () {
    var a = [
    ];
    a.push({
      path: './sounds/',
      filename: 'card',
      loop: !1,
      volume: 1,
      ingamename: 'card'
    });
    a.push({
      path: './sounds/',
      filename: 'chip',
      loop: !1,
      volume: 1,
      ingamename: 'chip'
    });
    a.push({
      path: './sounds/',
      filename: 'fiche_collect',
      loop: !1,
      volume: 1,
      ingamename: 'fiche_collect'
    });
    a.push({
      path: './sounds/',
      filename: 'press_but',
      loop: !1,
      volume: 1,
      ingamename: 'press_but'
    });
    a.push({
      path: './sounds/',
      filename: 'win',
      loop: !1,
      volume: 1,
      ingamename: 'win'
    });
    a.push({
      path: './sounds/',
      filename: 'lose',
      loop: !1,
      volume: 1,
      ingamename: 'lose'
    });
    c += a.length;
    s_aSounds = [
    ];
    for (var b = 0; b < a.length; b++) s_aSounds[a[b].ingamename] = new Howl({
      src: [
        a[b].path + a[b].filename + '.mp3'
      ],
      autoplay: !1,
      preload: !0,
      loop: a[b].loop,
      volume: a[b].volume,
      onload: s_oMain.soundLoaded
    })
  };
  this._loadImages = function () {
    s_oSpriteLibrary.init(this._onImagesLoaded, this._onAllImagesLoaded, this);
    s_oSpriteLibrary.addSprite('but_menu_bg', './sprites/but_menu_bg.png');
    s_oSpriteLibrary.addSprite('but_game_bg', './sprites/but_game_bg.png');
    s_oSpriteLibrary.addSprite('but_exit', './sprites/but_exit.png');
    s_oSpriteLibrary.addSprite('bg_menu', './sprites/bg_menu.jpg');
    s_oSpriteLibrary.addSprite('audio_icon', './sprites/audio_icon.png');
    s_oSpriteLibrary.addSprite('bg_game', './sprites/bg_game.jpg');
    s_oSpriteLibrary.addSprite('card_spritesheet', './sprites/card_spritesheet.png');
    s_oSpriteLibrary.addSprite('msg_box', './sprites/msg_box.png');
    s_oSpriteLibrary.addSprite('display_bg', './sprites/display_bg.png');
    s_oSpriteLibrary.addSprite('fiche_highlight', './sprites/fiche_highlight.png');
    s_oSpriteLibrary.addSprite('bet_banker', './sprites/bet_banker.png');
    s_oSpriteLibrary.addSprite('bet_tie', './sprites/bet_tie.png');
    s_oSpriteLibrary.addSprite('bet_player', './sprites/bet_player.png');
    s_oSpriteLibrary.addSprite('win_bg', './sprites/win_bg.png');
    s_oSpriteLibrary.addSprite('history_cell', './sprites/history_cell.png');
    s_oSpriteLibrary.addSprite('history_highlight', './sprites/history_highlight.png');
    s_oSpriteLibrary.addSprite('history_bg', './sprites/history_bg.png');
    s_oSpriteLibrary.addSprite('but_clear', './sprites/but_clear.png');
    s_oSpriteLibrary.addSprite('but_deal', './sprites/but_deal.png');
    s_oSpriteLibrary.addSprite('but_rebet', './sprites/but_rebet.png');
    s_oSpriteLibrary.addSprite('gui_bg', './sprites/gui_bg.png');
    s_oSpriteLibrary.addSprite('but_fullscreen', './sprites/but_fullscreen.png');
    s_oSpriteLibrary.addSprite('logo_credits', './sprites/logo_credits.png');
    s_oSpriteLibrary.addSprite('but_credits', './sprites/but_credits.png');
    for (var a = 0; a < NUM_FICHES; a++) s_oSpriteLibrary.addSprite('fiche_' + a, './sprites/fiche_' + a + '.png');
    c += s_oSpriteLibrary.getNumSprites();
    s_oSpriteLibrary.loadSprites()
  };
  this._onImagesLoaded = function () {
    b++;
    f.refreshLoader(Math.floor(b / c * 100))
  };
  this._onAllImagesLoaded = function () {
  };
  this._onRemovePreloader = function () {
    f.unload();
    this.gotoMenu()
  };
  this.gotoMenu = function () {
    new CMenu;
    e = STATE_MENU
  };
  this.gotoGame = function () {
    k = new CGame(r);
    e = STATE_GAME
  };
  this.gotoHelp = function () {
    new CHelp;
    e = STATE_HELP
  };
  this.stopUpdate = function () {
    d = !1;
    createjs.Ticker.paused = !0;
    $('#block_game').css('display', 'block');
    !1 !== DISABLE_SOUND_MOBILE && !1 !== s_bMobile || Howler.mute(!0)
  };
  this.startUpdate = function () {
    s_iPrevTime = (new Date).getTime();
    d = !0;
    createjs.Ticker.paused = !1;
    $('#block_game').css('display', 'none');
    (!1 === DISABLE_SOUND_MOBILE || !1 === s_bMobile) && s_bAudioActive && Howler.mute(!1)
  };
  this._update = function (a) {
    if (d) {
      var b = (new Date).getTime();
      s_iTimeElaps = b - s_iPrevTime;
      s_iCntTime += s_iTimeElaps;
      s_iCntFps++;
      s_iPrevTime = b;
      1000 <= s_iCntTime && (s_iCurFps = s_iCntFps, s_iCntTime -= 1000, s_iCntFps = 0);
      e === STATE_GAME && k.update();
      s_oStage.update(a)
    }
  };
  s_oMain = this;
  var r = a;
  ENABLE_CHECK_ORIENTATION = r.check_orientation;
  ENABLE_FULLSCREEN = r.fullscreen;
  SHOW_CREDITS = false;
  this.initContainer()
}
var s_bMobile,
s_bAudioActive = !0,
s_iCntTime = 0,
s_iTimeElaps = 0,
s_iPrevTime = 0,
s_iCntFps = 0,
s_iCurFps = 0,
s_oDrawLayer,
s_oStage,
s_oMain,
s_oSpriteLibrary,
s_oGameSettings,
s_bFullscreen = !1;
function CTextButton(a, d, b, c, e, f, k, r) {
  var q,
  n,
  p,
  g,
  l,
  m,
  v,
  t,
  D,
  C;
  this._init = function (a, b, c, d, e, g, f, l) {
    q = !1;
    n = [
    ];
    p = [
    ];
    C = l;
    v = createBitmap(c);
    l = Math.ceil(f / 20);
    t = new createjs.Text(d, f + 'px ' + e, '#000000');
    var k = t.getBounds();
    t.textAlign = 'center';
    t.textBaseline = 'alphabetic';
    t.x = c.width / 2 + l;
    t.y = Math.floor(c.height / 2) + k.height / 3 + l;
    D = new createjs.Text(d, f + 'px ' + e, g);
    D.textAlign = 'center';
    D.textBaseline = 'alphabetic';
    D.x = c.width / 2;
    D.y = Math.floor(c.height / 2) + k.height / 3;
    m = new createjs.Container;
    m.x = a;
    m.y = b;
    m.regX = c.width / 2;
    m.regY = c.height / 2;
    m.cursor = 'pointer';
    m.addChild(v, t, D);
    C.addChild(m);
    this._initListener()
  };
  this.unload = function () {
    m.off('mousedown', g);
    m.off('pressup', l);
    C.removeChild(m)
  };
  this.setVisible = function (a) {
    m.visible = a
  };
  this.enable = function () {
    q = !1;
    D.color = '#fff'
  };
  this.disable = function () {
    q = !0;
    D.color = '#a39b9d'
  };
  this._initListener = function () {
    g = m.on('mousedown', this.buttonDown);
    l = m.on('pressup', this.buttonRelease)
  };
  this.addEventListener = function (a, b, c) {
    n[a] = b;
    p[a] = c
  };
  this.buttonRelease = function () {
    q || (playSound('press_but', 1, !1), m.scaleX = 1, m.scaleY = 1, n[ON_MOUSE_UP] && n[ON_MOUSE_UP].call(p[ON_MOUSE_UP]))
  };
  this.buttonDown = function () {
    q || (m.scaleX = 0.9, m.scaleY = 0.9, n[ON_MOUSE_DOWN] && n[ON_MOUSE_DOWN].call(p[ON_MOUSE_DOWN]))
  };
  this.setPosition = function (a, b) {
    m.x = a;
    m.y = b
  };
  this.changeText = function (a) {
    D.text = a;
    t.text = a
  };
  this.setX = function (a) {
    m.x = a
  };
  this.setY = function (a) {
    m.y = a
  };
  this.getButtonImage = function () {
    return m
  };
  this.getX = function () {
    return m.x
  };
  this.getY = function () {
    return m.y
  };
  this._init(a, d, b, c, e, f, k, r);
  return this
}
function CGfxButton(a, d, b, c) {
  var e,
  f,
  k,
  r,
  q,
  n = [
  ],
  p,
  g,
  l;
  this._init = function (a, b, c) {
    e = !1;
    r = [
    ];
    q = [
    ];
    f = c.width;
    k = c.height;
    l = createBitmap(c);
    l.x = a;
    l.y = b;
    l.regX = c.width / 2;
    l.regY = c.height / 2;
    l.cursor = 'pointer';
    m.addChild(l);
    this._initListener()
  };
  this.unload = function () {
    l.off('mousedown', p);
    l.off('pressup', g);
    m.removeChild(l)
  };
  this.setVisible = function (a) {
    l.visible = a
  };
  this._initListener = function () {
    p = l.on('mousedown', this.buttonDown);
    g = l.on('pressup', this.buttonRelease)
  };
  this.addEventListener = function (a, b, c) {
    r[a] = b;
    q[a] = c
  };
  this.addEventListenerWithParams = function (a, b, c, d) {
    r[a] = b;
    q[a] = c;
    n = d
  };
  this.buttonRelease = function (a) {
    a.stopPropagation();
    a.preventDefault();
    e || (playSound('press_but', 1, !1), r[ON_MOUSE_UP] && r[ON_MOUSE_UP].call(q[ON_MOUSE_UP], n))
  };
  this.buttonDown = function () {
    e || r[ON_MOUSE_DOWN] && r[ON_MOUSE_DOWN].call(q[ON_MOUSE_DOWN], n)
  };
  this.setPosition = function (a, b) {
    l.x = a;
    l.y = b
  };
  this.setX = function (a) {
    l.x = a
  };
  this.setY = function (a) {
    l.y = a
  };
  this.enable = function () {
    e = !1;
    l.filters = [
    ];
    l.cache(0, 0, f, k)
  };
  this.disable = function () {
    e = !0;
    var a = (new createjs.ColorMatrix).adjustSaturation( - 100).adjustBrightness(40);
    l.filters = [
      new createjs.ColorMatrixFilter(a)
    ];
    l.cache(0, 0, f, k)
  };
  this.getButtonImage = function () {
    return l
  };
  this.getX = function () {
    return l.x
  };
  this.getY = function () {
    return l.y
  };
  var m = c;
  this._init(a, d, b);
  return this
}
function CGuiButton(a, d, b, c, e, f, k, r) {
  var q,
  n,
  p,
  g,
  l,
  m,
  v;
  this._init = function (a, b, c, d, e, f, k, r) {
    q = !1;
    n = [
    ];
    p = [
    ];
    v = r;
    l = createBitmap(c);
    m = new createjs.Text(d, k + 'px ' + e, f);
    m.textAlign = 'left';
    m.textBaseline = 'alphabetic';
    m.x = 10;
    m.y = c.height - 10;
    g = new createjs.Container;
    g.x = a;
    g.y = b;
    g.regX = c.width / 2;
    g.regY = c.height / 2;
    g.addChild(l, m);
    v.addChild(g);
    this._initListener()
  };
  this.unload = function () {
    g.off('mousedown');
    g.off('pressup');
    v.removeChild(g)
  };
  this.setVisible = function (a) {
    g.visible = a
  };
  this.enable = function () {
    q = !1;
    m.color = '#fff'
  };
  this.disable = function () {
    q = !0;
    m.color = '#a39b9d'
  };
  this._initListener = function () {
    g.on('mousedown', this.buttonDown);
    g.on('pressup', this.buttonRelease)
  };
  this.addEventListener = function (a, b, c) {
    n[a] = b;
    p[a] = c
  };
  this.buttonRelease = function () {
    q || (playSound('press_but', 1, !1), g.scaleX = 1, g.scaleY = 1, n[ON_MOUSE_UP] && n[ON_MOUSE_UP].call(p[ON_MOUSE_UP]))
  };
  this.buttonDown = function () {
    q || (g.scaleX = 0.9, g.scaleY = 0.9, n[ON_MOUSE_DOWN] && n[ON_MOUSE_DOWN].call(p[ON_MOUSE_DOWN]))
  };
  this.setPosition = function (a, b) {
    g.x = a;
    g.y = b
  };
  this.changeText = function (a) {
    m.text = a
  };
  this.setX = function (a) {
    g.x = a
  };
  this.setY = function (a) {
    g.y = a
  };
  this.getButtonImage = function () {
    return g
  };
  this.getX = function () {
    return g.x
  };
  this.getY = function () {
    return g.y
  };
  this._init(a, d, b, c, e, f, k, r);
  return this
}
function CToggle(a, d, b, c, e) {
  var f,
  k,
  r,
  q,
  n = [
  ],
  p,
  g,
  l;
  this._init = function (a, b, c, d, e) {
    r = [
    ];
    q = [
    ];
    var g = new createjs.SpriteSheet({
      images: [
        c
      ],
      frames: {
        width: c.width / 2,
        height: c.height,
        regX: c.width / 2 / 2,
        regY: c.height / 2
      },
      animations: {
        state_true: [
          0
        ],
        state_false: [
          1
        ]
      }
    });
    f = d;
    k = e;
    l = createSprite(g, 'state_' + f, c.width / 2 / 2, c.height / 2, c.width / 2, c.height);
    l.x = a;
    l.y = b;
    l.cursor = 'pointer';
    l.stop();
    s_oStage.addChild(l);
    this._initListener()
  };
  this.unload = function () {
    l.off('mousedown', p);
    l.off('pressup', g);
    s_oStage.removeChild(l)
  };
  this._initListener = function () {
    p = l.on('mousedown', this.buttonDown);
    g = l.on('pressup', this.buttonRelease)
  };
  this.addEventListener = function (a, b, c) {
    r[a] = b;
    q[a] = c
  };
  this.addEventListenerWithParams = function (a, b, c, d) {
    r[a] = b;
    q[a] = c;
    n = d
  };
  this.setActive = function (a) {
    f = a;
    l.gotoAndStop('state_' + f)
  };
  this.buttonRelease = function () {
    l.scaleX = 1;
    l.scaleY = 1;
    playSound('press_but', 1, !1);
    k && (f = !f, l.gotoAndStop('state_' + f));
    r[ON_MOUSE_UP] && r[ON_MOUSE_UP].call(q[ON_MOUSE_UP], n)
  };
  this.buttonDown = function () {
    l.scaleX = 0.9;
    l.scaleY = 0.9;
    r[ON_MOUSE_DOWN] && r[ON_MOUSE_DOWN].call(q[ON_MOUSE_DOWN], n)
  };
  this.setPosition = function (a, b) {
    l.x = a;
    l.y = b
  };
  this.setVisible = function (a) {
    l.visible = a
  };
  this.getY = function () {
    return l.y
  };
  this._init(a, d, b, c, e)
}
function CMenu() {
  var a,
  d,
  b,
  c,
  e,
  f,
  k,
  r = null,
  q = null,
  n,
  p,
  g,
  l,
  m;
  this._init = function () {
    p = createBitmap(s_oSpriteLibrary.getSprite('bg_menu'));
    s_oStage.addChild(p);
    var v = s_oSpriteLibrary.getSprite('but_menu_bg');
    g = new CGfxButton(CANVAS_WIDTH / 2, CANVAS_HEIGHT - 164, v, s_oStage);
    g.addEventListener(ON_MOUSE_UP, this._onButPlayRelease, this);
    if (!1 === DISABLE_SOUND_MOBILE || !1 === s_bMobile) v = s_oSpriteLibrary.getSprite('audio_icon'),
    e = CANVAS_WIDTH - v.width / 4 - 10,
    f = v.height / 2 + 10,
    l = new CToggle(e, f, v, s_bAudioActive, !0),
    l.addEventListener(ON_MOUSE_UP, this._onAudioToggle, this);
    SHOW_CREDITS ? (v = s_oSpriteLibrary.getSprite('but_credits'), a = 10 + v.width / 2, d = v.height / 2 + 10, n = new CGfxButton(a, d, v, s_oStage), n.addEventListener(ON_MOUSE_UP, this._onCredits, this), b = a + v.width + 10, c = d)  : (v = s_oSpriteLibrary.getSprite('but_fullscreen'), b = 10 + v.width / 4, c = v.height / 2 + 10);
    v = window.document;
    var t = v.documentElement;
    r = t.requestFullscreen || t.mozRequestFullScreen || t.webkitRequestFullScreen || t.msRequestFullscreen;
    q = v.exitFullscreen || v.mozCancelFullScreen || v.webkitExitFullscreen || v.msExitFullscreen;
    !1 === ENABLE_FULLSCREEN && (r = !1);
    r && screenfull.enabled && (v = s_oSpriteLibrary.getSprite('but_fullscreen'), k = new CToggle(b, c, v, s_bFullscreen, s_oStage), k.addEventListener(ON_MOUSE_UP, this._onFullscreenRelease, this));
    m = new createjs.Shape;
    m.graphics.beginFill('black').drawRect(0, 0, CANVAS_WIDTH, CANVAS_HEIGHT);
    s_oStage.addChild(m);
    createjs.Tween.get(m).to({
      alpha: 0
    }, 400).call(function () {
      m.visible = !1
    });
    this.refreshButtonPos(s_iOffsetX, s_iOffsetY)
  };
  this.refreshButtonPos = function (g, m) {
    !1 !== DISABLE_SOUND_MOBILE && !1 !== s_bMobile || l.setPosition(e - g, m + f);
    r && screenfull.enabled && k.setPosition(b + g, c + m);
    SHOW_CREDITS && n.setPosition(a + g, d + m)
  };
  this.unload = function () {
    g.unload();
    g = null;
    SHOW_CREDITS && n.unload();
    if (!1 === DISABLE_SOUND_MOBILE || !1 === s_bMobile) l.unload(),
    l = null;
    r && screenfull.enabled && k.unload();
    s_oStage.removeAllChildren();
    s_oMenu = null
  };
  this._onButPlayRelease = function () {
    this.unload();
    s_oMain.gotoGame();
    $(s_oMain).trigger('start_session')
  };
  this._onCredits = function () {
    new CCreditsPanel
  };
  this._onAudioToggle = function () {
    Howler.mute(s_bAudioActive);
    s_bAudioActive = !s_bAudioActive
  };
  this.resetFullscreenBut = function () {
    r && screenfull.enabled && k.setActive(s_bFullscreen)
  };
  this._onFullscreenRelease = function () {
    s_bFullscreen ? q.call(window.document)  : r.call(window.document.documentElement);
    sizeHandler()
  };
  s_oMenu = this;
  this._init()
}
var s_oMenu = null;
function CGame(a) {
  var d = !1,
  b,
  c,
  e,
  f,
  k,
  r,
  q,
  n,
  p,
  g,
  l,
  m,
  v,
  t,
  D,
  C,
  F,
  H,
  I,
  J,
  K,
  N,
  z,
  x,
  O,
  P;
  this._init = function () {
    e = MAX_BET;
    f = - 1;
    n = c = 0;
    t = [
    ];
    for (var a = 0; a < BET_OCCURRENCE.length; a++) for (var b = 0; b < BET_OCCURRENCE[a]; b++) t.push(a);
    s_oTweenController = new CTweenController;
    N = createBitmap(s_oSpriteLibrary.getSprite('bg_game'));
    s_oStage.addChild(N);
    a = s_oSpriteLibrary.getSprite('gui_bg');
    b = createBitmap(a);
    b.y = CANVAS_HEIGHT - a.height;
    s_oStage.addChild(b);
    K = new createjs.Container;
    s_oStage.addChild(K);
    z = new CInterface(TOTAL_MONEY);
    z.displayMsg(TEXT_DISPLAY_MSG_WAITING_BET, TEXT_MIN_BET + ': ' + MIN_BET + '\n' + TEXT_MAX_BET + ': ' + MAX_BET);
    x = new CSeat;
    x.setCredit(TOTAL_MONEY);
    this.reset(!1);
    C = new CVector2;
    C.set(1214, 228);
    F = new CVector2;
    F.set(CANVAS_WIDTH / 2 + 100, 230);
    H = new CVector2;
    H.set(418, 820);
    I = new CVector2;
    I.set(0, - CANVAS_HEIGHT);
    J = new CVector2(454, 230);
    v = [
      x.getCardOffset(),
      F
    ];
    P = new CGameOver;
    x.getCredit() < s_oGameSettings.getFichesValueAt(0) ? (this._gameOver(), this.changeState( - 1))  : d = !0;
    D = new CVector2(C.getX(), C.getY());
    O = new CMsgBox;
    this.changeState(STATE_GAME_WAITING_FOR_BET)
  };
  this.unload = function () {
    d = !1;
    for (var a = 0; a < p.length; a++) p[a].unload();
    z.unload();
    P.unload();
    O.unload();
    s_oStage.removeAllChildren()
  };
  this.reset = function (a) {
    b = !1;
    r = q = k = c = 0;
    x.reset();
    p = [
    ];
    p.splice(0);
    z.reset();
    z.enableBetFiches(a);
    this.shuffleCard()
  };
  this.shuffleCard = function () {
    l = [
    ];
    l = s_oGameSettings.getShuffledCardDeck()
  };
  this.changeState = function (a) {
    f = a;
    if (f === STATE_GAME_DEALING) {
      var b = E < 2 * x.getTotBet() ? WIN_OCCURRENCE : 100 * Math.random();
      a = x.getBetArray();
      for (var c = 0, d = 0; d < a.length; d++) 0 < a[d] && c++;
      if (b < WIN_OCCURRENCE) {
        if (1 === c) {
          for (d = 0; d < a.length; d++) {
            var e = 0;
            if (0 !== a[d]) {
              e = d;
              break
            }
          }
          d = e
        } else {
          do d = t[Math.floor(Math.random() * t.length)];
          while (0 === a[d])
        }
        do 6 > l.length && this.shuffleCard(),
        a = [
        ],
        a.push(l.splice(0, 1)),
        a.push(l.splice(0, 1)),
        b = [
        ],
        b.push(l.splice(0, 1)),
        b.push(l.splice(0, 1)),
        e = this._simulateHand(a, b);
        while (d !== e)
      } else {
        if (3 === c) b = Math.random(),
        d = 0.5 < b ? BET_BANKER : BET_PLAYER;
         else {
          d = [
          ];
          for (b = 0; b < a.length; b++) 0 === a[b] && d.push(b);
          b = Math.floor(Math.random() * d.length);
          d = d[b]
        }
        do 6 > l.length && this.shuffleCard(),
        a = [
        ],
        a.push(l.splice(0, 1)),
        a.push(l.splice(0, 1)),
        b = [
        ],
        b.push(l.splice(0, 1)),
        b.push(l.splice(0, 1)),
        e = this._simulateHand(a, b);
        while (d !== e)
      }
      m = [
      ];
      for (d = 0; d < a.length; d++) m[d] = a[d];
      g = [
      ];
      for (d = 0; d < b.length; d++) g[d] = b[d];
      z.disableButtons();
      z.displayMsg(TEXT_DISPLAY_MSG_DEALING);
      this._dealing()
    }
  };
  this._simulateHand = function (a, b) {
    for (var c = 0, d = 0, e = 0; e < a.length; e++) c += s_oGameSettings.getCardValue(a[e]),
    d += s_oGameSettings.getCardValue(b[e]);
    c %= 10;
    d %= 10;
    if (7 <
    d) return c = d > c ? WIN_DEALER : d === c ? WIN_TIE : WIN_PLAYER;
    e = !1;
    if (7 < c) return WIN_PLAYER;
    if (6 > c) {
      var g = l.splice(0, 1),
      f = s_oGameSettings.getCardValue(g);
      a.push(g);
      c = (c + f) % 10;
      3 > d ? e = !0 : 3 === d && 8 !== f ? e = !0 : 4 === d && 1 < f && 8 > f ? e = !0 : 5 === d && 3 < f && 8 > f ? e = !0 : 6 !== d || 6 !== f && 7 !== f || (e = !1);
      e && (g = l.splice(0, 1), b.push(g), d += s_oGameSettings.getCardValue(g), d %= 10)
    } else 6 > d && (g = l.splice(0, 1), b.push(g), d += s_oGameSettings.getCardValue(g), d %= 10);
    return d === c ? WIN_TIE : d > c ? WIN_DEALER : WIN_PLAYER
  };
  this.cardFromDealerArrived = function (a, b, c) {
    !1 ===
    b ? r += a.getValue()  : q += a.getValue();
    3 > c ? s_oGame._dealing()  : (r %= 10, q %= 10, z.refreshCardValue(q, r), 1 === m.length ? (a = m.splice(0, 1) [0], b = new CCard(C.getX(), C.getY(), K), b.setInfo(D, x.getAttachCardOffset(), a, s_oGameSettings.getCardValue(a), !1, k), b.addEventListener(ON_CARD_ANIMATION_ENDING, s_oGame.cardFromDealerArrived), x.newCardDealed(), k++, p.push(b))  : 1 === g.length ? (k++, c = new CVector2(F.getX() + CARD_WIDTH / 2 * 2, F.getY()), a = g.splice(0, 1), b = new CCard(C.getX(), C.getY(), K), b.setInfo(D, c, a, s_oGameSettings.getCardValue(a), !0, k), b.addEventListener(ON_CARD_ANIMATION_ENDING, s_oGame.cardFromDealerArrived), p.push(b))  : s_oGame._showWin())
  };
  this._showWin = function () {
    var a = q === r ? BET_TIE : q > r ? BET_BANKER : BET_PLAYER;
    var b = x.getBetArray(),
    c = !1;
    if (a === BET_TIE && 0 < b[BET_TIE]) {
      var d = x.getPotentialWin(BET_TIE);
      this._playerWin(d, a, !0);
      this._playerWin(b[BET_BANKER], BET_BANKER, !1);
      this._playerWin(b[BET_PLAYER], BET_PLAYER, !1);
      c = !0;
      z.showWin(BET_TIE, d);
      z.showWin(BET_BANKER, 0);
      z.showWin(BET_PLAYER, 0)
    } else for (var e = 0; e < b.length; e++) 0 < b[e] && (d = 0, a === e ? (this._playerWin(x.getPotentialWin(e), a), d = x.getPotentialWin(e), c = !0)  : this._playerLose(e), z.showWin(e, d));
    c ? playSound('win', 1, !1)  : playSound('lose', 1, !1);
    setTimeout(function () {
      s_oGame._onEndHand(a)
    }, TIME_END_HAND)
  };
  this._playerWin = function (a, b, c) {
    x.increaseCredit(a);
    E -= a;
    c && z.displayMsg(TEXT_DISPLAY_MSG_PLAYER_WIN, TEXT_BET[b] === BET_TIE ? TEXT_DISPLAY_TIE : TEXT_HAND_WON + ' ' + TEXT_BET[b]);
    x.initMovement(b, H.getX(), H.getY())
  };
  this._playerLose = function (a) {
    z.displayMsg(TEXT_DISPLAY_MSG_PLAYER_LOSE, TEXT_BET[a] === BET_TIE ? TEXT_DISPLAY_TIE : TEXT_HAND_WON + ' ' + TEXT_BET[a]);
    x.initMovement(a, I.getX(), I.getY())
  };
  this._dealing = function () {
    if (k < 2 * v.length) {
      var a = new CCard(C.getX(), C.getY(), K);
      if (1 === k % v.length) {
        var b = new CVector2(F.getX() + CARD_WIDTH / 2 * (1 < k ? 1 : 0), F.getY());
        var c = g.splice(0, 1) [0];
        a.setInfo(D, b, c, s_oGameSettings.getCardValue(c), !0, k)
      } else c = m.splice(0, 1) [0],
      a.setInfo(D, x.getAttachCardOffset(), c, s_oGameSettings.getCardValue(c), !1, k),
      x.newCardDealed();
      p.push(a);
      k++;
      a.addEventListener(ON_CARD_ANIMATION_ENDING, this.cardFromDealerArrived);
      a.addEventListener(ON_CARD_TO_REMOVE, this._onRemoveCard);
      playSound('card', 1, !1)
    }
  };
  this._onEndHand = function (a) {
    z.addHistoryRow(r, q, a);
    a = new CVector2(J.getX(), J.getY());
    for (var b = 0; b < p.length; b++) p[b].initRemoving(a),
    p[b].hideCard();
    z.clearCardValueText();
    c = 0;
    s_oGame.changeState(STATE_GAME_SHOW_WINNER);
    playSound('fiche_collect', 1, !1);
    n++;
    n === AD_SHOW_COUNTER && (n = 0, $(s_oMain).trigger('show_interlevel_ad'));
    $(s_oMain).trigger('save_score', [
      x.getCredit()
    ])
  };
  this.setBet = function (a, c, d) {
    b && (b = !1, this.clearBets());
    var g = x.getTotBet();
    g + a <= e && a <= x.getCredit() && ((g + a).toFixed(2), x.decreaseCredit(a), E += a, x.bet(a, d, c), z.enable(!0, !1, !1, !1, !1), z.refreshCredit(x.getCredit()))
  };
  this._gameOver = function () {
    P.show()
  };
  this.onDeal = function () {
    x.getTotBet() < MIN_BET ? (O.show(TEXT_ERROR_MIN_BET), z.enableBetFiches(!1), z.enable(!0))  : ($(s_oMain).trigger('bet_placed', x.getTotBet()), x.calculatePotentialWins(), this.changeState(STATE_GAME_DEALING))
  };
  this.clearBets = function () {
    var a = x.getStartingBet();
    if (0 < a) {
      x.clearBet();
      x.increaseCredit(a);
      E -= a;
      z.refreshCredit(x.getCredit());
      var b = x.checkIfRebetIsPossible();
      z.enableBetFiches(b);
      $(s_oMain).trigger('clear_bet', a)
    }
  };
  this.rebet = function () {
    this.clearBets();
    var a = x.rebet();
    E -= a;
    z.enable(!0, !1, !1, !1, !1);
    z.refreshCredit(x.getCredit());
    c = BET_TIME;
    b = !0
  };
  this._onRemoveCard = function (a) {
    a.unload();
    z.displayMsg(TEXT_DISPLAY_MSG_WAITING_BET, TEXT_MIN_BET + ': ' + MIN_BET + '\n' + TEXT_MAX_BET + ': ' + MAX_BET)
  };
  this.onExit = function () {
    this.unload();
    $(s_oMain).trigger('end_session');
    $(s_oMain).trigger('share_event', x.getCredit());
    s_oMain.gotoMenu()
  };
  this.getState = function () {
    return f
  };
  this._updateDealing = function () {
    for (var a = 0; a < p.length; a++) p[a].update()
  };
  this._updateShowWinner = function () {
    x.updateFichesController(s_iTimeElaps);
    for (var a = 0; a < p.length; a++) p[a].update();
    c += s_iTimeElaps;
    c > TIME_END_HAND && (c = 0, a = x.checkIfRebetIsPossible(), this.reset(a), z.reset(), x.getCredit() < s_oGameSettings.getFichesValueAt(0) ? (this._gameOver(), this.changeState( - 1))  : this.changeState(STATE_GAME_WAITING_FOR_BET), z.refreshCredit(x.getCredit()))
  };
  this.update = function () {
    if (!1 !== d) switch (f) {
      case STATE_GAME_DEALING:
        this._updateDealing();
        break;
      case STATE_GAME_SHOW_WINNER:
        this._updateShowWinner()
    }
  };
  s_oGame = this;
  TOTAL_MONEY = a.money;
  MIN_BET = a.min_bet;
  MAX_BET = a.max_bet;
  MULTIPLIERS = a.multiplier;
  BET_TIME = a.bet_time;
  BLACKJACK_PAYOUT = a.blackjack_payout;
  WIN_OCCURRENCE = a.win_occurrence;
  BET_OCCURRENCE = a.bet_occurrence;
  var E = a.game_cash;
  TIME_END_HAND = a.time_show_hand;
  AD_SHOW_COUNTER = a.ad_show_counter;
  this._init()
}
var s_oGame,
s_oTweenController;
function CInterface(a) {
  var d,
  b,
  c,
  e,
  f,
  k,
  r,
  q,
  n,
  p,
  g,
  l,
  m,
  v,
  t,
  D,
  C = null,
  F,
  H,
  I,
  J,
  K,
  N,
  z,
  x,
  O,
  P,
  E,
  Q = null,
  T = null;
  this._init = function (a) {
    var y = s_oSpriteLibrary.getSprite('but_exit');
    f = CANVAS_WIDTH - y.width / 2 - 10;
    k = y.height / 2 + 10;
    m = new CGfxButton(f, k, y, s_oStage);
    m.addEventListener(ON_MOUSE_UP, this._onExit, this);
    if (!1 === DISABLE_SOUND_MOBILE || !1 === s_bMobile) r = m.getX() - y.width - 10,
    q = y.height / 2 + 10,
    C = new CToggle(r, q, s_oSpriteLibrary.getSprite('audio_icon'), s_bAudioActive, !0),
    C.addEventListener(ON_MOUSE_UP, this._onAudioToggle, this);
    y = window.document;
    var L = y.documentElement;
    Q = L.requestFullscreen || L.mozRequestFullScreen || L.webkitRequestFullScreen || L.msRequestFullscreen;
    T = y.exitFullscreen || y.mozCancelFullScreen || y.webkitExitFullscreen || y.msExitFullscreen;
    !1 === ENABLE_FULLSCREEN && (Q = !1);
    Q && screenfull.enabled && (y = s_oSpriteLibrary.getSprite('but_fullscreen'), null === C ? (d = m.getX() - y.width / 2 - 10, b = y.height / 2 + 10)  : (d = r - y.width / 2 - 10, b = y.height / 2 + 10), E = new CToggle(d, b, y, s_bFullscreen, !0), E.addEventListener(ON_MOUSE_UP, this._onFullscreenRelease, this));
    y = createBitmap(s_oSpriteLibrary.getSprite('display_bg'));
    y.x = 290;
    y.y = 6;
    s_oStage.addChild(y);
    O = new CGfxButton(CANVAS_WIDTH / 2, 590, s_oSpriteLibrary.getSprite('bet_player'), s_oStage);
    O.addEventListener(ON_MOUSE_UP, this._onButPlayerRelease, this);
    x = new CGfxButton(CANVAS_WIDTH / 2, 482, s_oSpriteLibrary.getSprite('bet_banker'), s_oStage);
    x.addEventListener(ON_MOUSE_UP, this._onButBankerRelease, this);
    z = new CGfxButton(CANVAS_WIDTH / 2, 400, s_oSpriteLibrary.getSprite('bet_tie'), s_oStage);
    z.addEventListener(ON_MOUSE_UP, this._onButTieRelease, this);
    y = s_oSpriteLibrary.getSprite('but_clear');
    v = new CGuiButton(939, CANVAS_HEIGHT - 31, y, TEXT_CLEAR, FONT_GAME_1, '#ffffff', 17, s_oStage);
    v.addEventListener(ON_MOUSE_UP, this._onButClearRelease, this);
    y = s_oSpriteLibrary.getSprite('but_rebet');
    t = new CGuiButton(1112, CANVAS_HEIGHT - y.height / 2, y, TEXT_REBET, FONT_GAME_1, '#ffffff', 17, s_oStage);
    t.disable();
    t.addEventListener(ON_MOUSE_UP, this._onButRebetRelease, this);
    J = new createjs.Text('', '24px ' + FONT_GAME_2, '#ffde00');
    J.x = 412;
    J.y = 16;
    J.lineWidth = 150;
    J.textAlign = 'left';
    J.lineHeight = 20;
    s_oStage.addChild(J);
    K = new createjs.Text('', '19px ' + FONT_GAME_2, '#ffde00');
    K.x = 412;
    K.y = 66;
    J.lineWidth = 180;
    K.textAlign = 'left';
    K.lineHeight = 18;
    s_oStage.addChild(K);
    H = new createjs.Text('', '20px ' + FONT_GAME_1, '#fff');
    H.shadow = new createjs.Shadow('#000000', 2, 2, 1);
    H.x = 910;
    H.y = 180;
    H.textAlign = 'right';
    s_oStage.addChild(H);
    I = new createjs.Text('', '20px ' + FONT_GAME_1, '#fff');
    I.shadow = new createjs.Shadow('#000000', 2, 2, 1);
    I.x = 658;
    I.y = 180;
    I.textAlign = 'right';
    s_oStage.addChild(I);
    y = new createjs.Text(TEXT_MONEY + ':', '30px ' + FONT_GAME_2, '#ffde00');
    y.x = 370;
    y.y = CANVAS_HEIGHT - 84;
    y.textAlign = 'left';
    s_oStage.addChild(y);
    F = new createjs.Text(TEXT_CURRENCY + a.toFixed(3), '30px ' + FONT_GAME_2, '#ffde00');
    F.x = 460;
    F.y = CANVAS_HEIGHT - 84;
    F.textAlign = 'left';
    s_oStage.addChild(F);
    y = s_oSpriteLibrary.getSprite('but_deal');
    D = new CGuiButton(1282, CANVAS_HEIGHT - y.height / 2, y, TEXT_DEAL, FONT_GAME_1, '#ffffff', 26, s_oStage);
    D.addEventListener(ON_MOUSE_UP, this._onButDealRelease, this);
    l = [
    ];
    l[BET_TIE] = new CWinDisplay(CANVAS_WIDTH +
    100, 360, s_oStage);
    l[BET_BANKER] = new CWinDisplay(CANVAS_WIDTH + 100, 460, s_oStage);
    l[BET_PLAYER] = new CWinDisplay(CANVAS_WIDTH + 100, 580, s_oStage);
    POS_BET[BET_TIE] = {
      x: z.getX(),
      y: z.getY()
    };
    POS_BET[BET_BANKER] = {
      x: x.getX(),
      y: x.getY()
    };
    POS_BET[BET_PLAYER] = {
      x: O.getX(),
      y: O.getY()
    };
    L = [
      {
        x: 387,
        y: CANVAS_HEIGHT - 24
      },
      {
        x: 467,
        y: CANVAS_HEIGHT - 24
      },
      {
        x: 547,
        y: CANVAS_HEIGHT - 24
      },
      {
        x: 627,
        y: CANVAS_HEIGHT - 24
      },
      {
        x: 707,
        y: CANVAS_HEIGHT - 24
      },
      {
        x: 787,
        y: CANVAS_HEIGHT - 24
      }
    ];
    g = [
    ];
    a = s_oGameSettings.getFichesValues();
    for (var G = 0; G < NUM_FICHES; G++) y = s_oSpriteLibrary.getSprite('fiche_' + G),
    g[G] = new CGfxButton(L[G].x, L[G].y, y, s_oStage),
    g[G].addEventListenerWithParams(ON_MOUSE_UP, this._onFicheClicked, this, [
      a[G],
      G
    ]);
    L = s_oSpriteLibrary.getSprite('fiche_highlight');
    N = createBitmap(L);
    N.regX = L.width / 2;
    N.regY = L.height / 2;
    N.x = g[0].getX();
    N.y = g[0].getY();
    s_oStage.addChild(N);
    n = a[0];
    p = 0;
    FICHE_WIDTH = y.width;
    c = 10;
    e = 265;
    P = new CHistory(c, e, s_oStage);
    this.disableButtons();
    this.refreshButtonPos(s_iOffsetX, s_iOffsetY)
  };
  this.unload = function () {
    m.unload();
    m = null;
    !1 ===
    DISABLE_SOUND_MOBILE && (C.unload(), C = null);
    Q && screenfull.enabled && E.unload();
    v.unload();
    x.unload();
    O.unload();
    z.unload();
    D.unload();
    t.unload();
    s_oInterface = null
  };
  this.refreshButtonPos = function (a, g) {
    m.setPosition(f - a, g + k);
    !1 !== DISABLE_SOUND_MOBILE && !1 !== s_bMobile || C.setPosition(r - a, g + q);
    Q && screenfull.enabled && E.setPosition(d - a, b + g);
    P.setPosition(c + a, e)
  };
  this.reset = function () {
    this.disableButtons()
  };
  this.enableBetFiches = function (a) {
    for (var b = 0; b < NUM_FICHES; b++) g[b].enable();
    v.enable();
    a && t.enable();
    z.enable();
    x.enable();
    O.enable()
  };
  this.disableBetFiches = function () {
    for (var a = 0; a < NUM_FICHES; a++) g[a].disable();
    v.disable();
    t.disable();
    z.disable();
    x.disable();
    O.disable()
  };
  this.disableButtons = function () {
    D.disable()
  };
  this.enable = function (a) {
    a ? D.enable()  : D.disable()
  };
  this.refreshCredit = function (a) {
    F.text = TEXT_CURRENCY + a.toFixed(3)
  };
  this.refreshCardValue = function (a, b) {
    H.text = '' + a;
    I.text = '' + b
  };
  this.displayMsg = function (a, b) {
    J.text = a;
    K.text = b
  };
  this.clearCardValueText = function () {
    H.text = '';
    I.text = ''
  };
  this._onFicheClicked = function (a) {
    this.hideAllWins();
    N.x = g[a[1]].getX();
    N.y = g[a[1]].getY();
    n = a[0];
    p = a[1]
  };
  this.showWin = function (a, b) {
    l[a].show(TEXT_SHOW_WIN[a], b)
  };
  this.hideAllWins = function () {
    for (var a = 0; a < l.length; a++) l[a].hide()
  };
  this.addHistoryRow = function (a, b, c) {
    P.addHistoryRow(a, b, c)
  };
  this._onButTieRelease = function () {
    this.hideAllWins();
    s_oGame.setBet(n, p, BET_TIE)
  };
  this._onButBankerRelease = function () {
    this.hideAllWins();
    s_oGame.setBet(n, p, BET_BANKER)
  };
  this._onButPlayerRelease = function () {
    this.hideAllWins();
    s_oGame.setBet(n, p, BET_PLAYER)
  };
  this._onButClearRelease = function () {
    s_oGame.clearBets()
  };
  this._onButRebetRelease = function () {
    this.hideAllWins();
    t.disable();
    s_oGame.rebet()
  };
  this._onButDealRelease = function () {
    this.disableBetFiches();
    this.disableButtons();
    s_oGame.onDeal()
  };
  this._onExit = function () {
    s_oGame.onExit()
  };
  this._onAudioToggle = function () {
    Howler.mute(s_bAudioActive);
    s_bAudioActive = !s_bAudioActive
  };
  this.resetFullscreenBut = function () {
    Q && screenfull.enabled && E.setActive(s_bFullscreen)
  };
  this._onFullscreenRelease = function () {
    s_bFullscreen ?
    T.call(window.document)  : Q.call(window.document.documentElement);
    sizeHandler()
  };
  s_oInterface = this;
  this._init(a);
  return this
}
var s_oInterface = null;
function CTweenController() {
  this.tweenValue = function (a, d, b) {
    return a + b * (d - a)
  };
  this.easeLinear = function (a, d, b, c) {
    return b * a / c + d
  };
  this.easeInCubic = function (a, d, b, c) {
    c = (a /= c) * a * a;
    return d + b * c
  };
  this.easeBackInQuart = function (a, d, b, c) {
    c = (a /= c) * a;
    return d + b * (2 * c * c + 2 * c * a + - 3 * c)
  };
  this.easeInBack = function (a, d, b, c) {
    return b * (a /= c) * a * (2.70158 * a - 1.70158) + d
  };
  this.easeOutCubic = function (a, d, b, c) {
    return b * ((a = a / c - 1) * a * a + 1) + d
  }
}
function CSeat() {
  var a,
  d,
  b,
  c,
  e,
  f,
  k,
  r,
  q,
  n,
  p;
  this._init = function () {
    q = new createjs.Container;
    q.x = CANVAS_WIDTH / 2 - 150;
    q.y = 230;
    s_oStage.addChild(q);
    p = [
    ];
    for (var a = 0; 3 > a; a++) p[a] = new CFichesController;
    e = 0;
    this.reset();
    n = new CVector2;
    n.set(0, 0);
    r = new CVector2(n.getX(), n.getY())
  };
  this.unload = function () {
    s_oStage.removeChild(q)
  };
  this.addEventListener = function (a, b, c) {
  };
  this.reset = function () {
    for (var e = c = b = d = a = 0; e < p.length; e++) p[e].reset();
    f = [
    ];
    for (e = 0; 3 > e; e++) f[e] = [
    ]
  };
  this.clearBet = function () {
    b = d = a = 0;
    f = [
    ];
    for (var c = 0; 3 > c; c++) p[c].reset(),
    f[c] = [
    ]
  };
  this.setCredit = function (a) {
    e = a
  };
  this.increaseCredit = function (a) {
    e += a
  };
  this.bet = function (c, e, f) {
    f = 0;
    switch (e) {
      case BET_TIE:
        f = a += c;
        break;
      case BET_BANKER:
        f = d += c;
        break;
      case BET_PLAYER:
        f = b += c
    }
    p[e].createFichesPile(f.toFixed(1), POS_BET[e].x, POS_BET[e].y)
  };
  this.calculatePotentialWins = function () {
    k = [
    ];
    k[BET_TIE] = a * MULTIPLIERS[BET_TIE];
    k[BET_BANKER] = d * MULTIPLIERS[BET_BANKER];
    k[BET_PLAYER] = b * MULTIPLIERS[BET_PLAYER];
    p[0].setPrevValue(a);
    p[1].setPrevValue(d);
    p[2].setPrevValue(b)
  };
  this.decreaseCredit = function (a) {
    e -= a
  };
  this.refreshFiches = function (a, b, c, d, e) {
    f[e].push({
      value: a,
      index: b
    });
    p[e].refreshFiches(f[e], c, d)
  };
  this.initMovement = function (a, b, c) {
    p[a].initMovement(b, c)
  };
  this.newCardDealed = function () {
    c++
  };
  this.rebet = function () {
    for (var c = 0, e = 0; e < p.length; e++) {
      var f = parseFloat(p[e].getPrevBet().toFixed(2));
      if (0 < f) {
        c += f;
        this.decreaseCredit(f);
        switch (e) {
          case BET_TIE:
            a += f;
            break;
          case BET_BANKER:
            d += f;
            break;
          case BET_PLAYER:
            b += f
        }
        p[e].createFichesPile(f, POS_BET[e].x, POS_BET[e].y)
      }
    }
    return c
  };
  this.checkIfRebetIsPossible = function () {
    for (var a = 0, b = 0; b < p.length; b++) {
      var c = parseFloat(p[b].getPrevBet().toFixed(2));
      a += c
    }
    return a > e ? !1 : !0
  };
  this.updateFichesController = function (a) {
    for (var b = 0; b < p.length; b++) p[b].update(a)
  };
  this.getAttachCardOffset = function () {
    r.set(q.x + n.getX() + CARD_WIDTH / 2 * c, q.y + n.getY());
    return r
  };
  this.getTotBet = function () {
    return a + d + b
  };
  this.getBetArray = function () {
    return [a,
    d,
    b]
  };
  this.getCredit = function () {
    return e
  };
  this.getCardOffset = function () {
    return n
  };
  this.getPotentialWin = function (a) {
    return k[a]
  };
  this.getStartingBet = function () {
    for (var a = 0, b = 0; b < p.length; b++) a += p[b].getValue();
    return a
  };
  this._init()
}
function CFichesController() {
  var a,
  d,
  b,
  c,
  e,
  f,
  k,
  r,
  q,
  n,
  p;
  this._init = function () {
    r = new createjs.Container;
    s_oStage.addChild(r);
    e = new CVector2;
    e.set(r.x, r.y);
    q = new createjs.Container;
    s_oStage.addChild(q);
    p = new createjs.Text('', '28px ' + FONT_GAME_1, '#000');
    p.textAlign = 'left';
    q.addChild(p);
    n = new createjs.Text('', '28px ' + FONT_GAME_1, '#fff');
    n.textAlign = 'left';
    q.addChild(n);
    b = c = d = 0;
    a = !1
  };
  this.addEventListener = function (a, b, c) {
  };
  this.reset = function () {
    a = !1;
    b = 0;
    r.removeAllChildren();
    r.x = e.getX();
    r.y = e.getY();
    p.text = '';
    n.text = ''
  };
  this.setPrevValue = function (a) {
    c = a
  };
  this.refreshFiches = function (a, c, d) {
    a = a.sortOn('value', 'index');
    for (var e = c, f = d, g = b = 0, k = 0; k < a.length; k++) {
      var l = createBitmap(s_oSpriteLibrary.getSprite('fiche_' + a[k].index));
      l.scaleX = 0.7;
      l.scaleY = 0.7;
      r.addChild(l);
      l.x = e;
      l.y = f;
      f -= 5;
      g++;
      9 < g && (g = 0, e += FICHE_WIDTH, f = d);
      b += a[k].value
    }
    playSound('chip', 1, !1);
    n.x = c;
    n.y = d + 30;
    n.text = b.toFixed(2) + TEXT_CURRENCY;
    p.x = c + 2;
    p.y = d + 32;
    p.text = b.toFixed(2) + TEXT_CURRENCY
  };
  this.createFichesPile = function (a, b, c) {
    this.reset();
    var d = s_oGameSettings.getFichesValues(),
    e = [
    ];
    do {
      for (var f = d[d.length - 1], g = d.length - 1; f > a; ) g--,
      f = d[g];
      g = Math.floor(a / f);
      for (var k = 0; k < g; k++) e.push({
        value: f,
        index: s_oGameSettings.getIndexForFiches(f)
      });
      f = Math.floor(a / f) === a / f ? 0 : a % f;
      a = f.toFixed(2)
    } while (0 < f);
    this.refreshFiches(e, b, c)
  };
  this.initMovement = function (d, e) {
    c = b;
    f = new CVector2(r.x, r.y);
    k = new CVector2(d, e);
    n.text = '';
    p.text = '';
    a = !0
  };
  this.getValue = function () {
    return b
  };
  this.getPrevBet = function () {
    return c
  };
  this.update = function (b) {
    if (a) if (d += b, d > TIME_FICHES_MOV) d = 0,
    a = !1;
     else {
      b = easeInOutCubic(d, 0, 1, TIME_FICHES_MOV);
      var c = new CVector2;
      c = tweenVectors(f, k, b, c);
      r.x = c.getX();
      r.y = c.getY()
    }
  };
  this._init()
}
function CVector2(a, d) {
  var b,
  c;
  this._init = function (a, d) {
    b = a;
    c = d
  };
  this.add = function (a, d) {
    b += a;
    c += d
  };
  this.addV = function (a) {
    b += a.getX();
    c += a.getY()
  };
  this.scalarDivision = function (a) {
    b /= a;
    c /= a
  };
  this.subV = function (a) {
    b -= a.getX();
    c -= a.getY()
  };
  this.scalarProduct = function (a) {
    b *= a;
    c *= a
  };
  this.invert = function () {
    b *= - 1;
    c *= - 1
  };
  this.dotProduct = function (a) {
    return b * a.getX() + c * a.getY()
  };
  this.set = function (a, d) {
    b = a;
    c = d
  };
  this.setV = function (a) {
    b = a.getX();
    c = a.getY()
  };
  this.length = function () {
    return Math.sqrt(b * b + c * c)
  };
  this.length2 = function () {
    return b * b + c * c
  };
  this.normalize = function () {
    var a = this.length();
    0 < a && (b /= a, c /= a)
  };
  this.getNormalize = function (a) {
    this.length();
    a.set(b, c);
    a.normalize()
  };
  this.rot90CCW = function () {
    var a = b;
    b = - c;
    c = a
  };
  this.rot90CW = function () {
    var a = b;
    b = c;
    c = - a
  };
  this.getRotCCW = function (a) {
    a.set(b, c);
    a.rot90CCW()
  };
  this.getRotCW = function (a) {
    a.set(b, c);
    a.rot90CW()
  };
  this.ceil = function () {
    b = Math.ceil(b);
    c = Math.ceil(c)
  };
  this.round = function () {
    b = Math.round(b);
    c = Math.round(c)
  };
  this.toString = function () {
    return 'Vector2: ' + b + ', ' +
    c
  };
  this.print = function () {
    trace('Vector2: ' + b + ', ' + c)
  };
  this.getX = function () {
    return b
  };
  this.getY = function () {
    return c
  };
  this._init(a, d)
}
function CGameSettings() {
  var a,
  d,
  b,
  c;
  this._init = function () {
    b = [
    ];
    a = [
    ];
    for (var d = 0; d < NUM_DECKS; d++) for (var f = 0; 52 > f; f++) {
      a.push(f);
      var k = (f + 1) % 13;
      if (10 < k || 0 === k) k = 10;
      b.push(k)
    }
    c = [
      0.1,
      1,
      5,
      10,
      25,
      100
    ]
  };
  this.getFichesValues = function () {
    return c
  };
  this.getFichesValueAt = function (a) {
    return c[a]
  };
  this.getIndexForFiches = function (a) {
    for (var b = 0, d = 0; d < c.length; d++) c[d] === a && (b = d);
    return b
  };
  this.generateFichesPile = function (a) {
    var b = [
    ],
    d = c.length - 1,
    e = c[d];
    do {
      var q = a % e;
      q = CMath.roundDecimal(q, 1);
      a = Math.floor(a / e);
      for (var n = 0; n < a; n++) b.push(e);
      d--;
      e = c[d];
      a = q
    } while (0 < q && - 1 < d);
    return b
  };
  this.timeToString = function (a) {
    a = Math.round(a / 1000);
    var b = Math.floor(a / 60);
    a -= 60 * b;
    var c = '';
    c = 10 > b ? c + ('0' + b + ':')  : c + (b + ':');
    return 10 > a ? c + ('0' + a)  : c + a
  };
  this.getShuffledCardDeck = function () {
    for (var b = [
    ], c = 0; c < a.length; c++) b[c] = a[c];
    for (d = [
    ]; 0 < b.length; ) d.push(b.splice(Math.round(Math.random() * (b.length - 1)), 1) [0]);
    return d
  };
  this.getCardValue = function (a) {
    return b[a]
  };
  this.getCardDeck = function () {
    return a
  };
  this._init()
}
var TYPE_LINEAR = 0,
TYPE_OUT_CUBIC = 1,
TYPE_IN_CUBIC = 2,
TYPE_OUT_BACK = 3,
TYPE_IN_BACK = 4;
function ease(a, d, b, c, e, f) {
  switch (a) {
    case TYPE_LINEAR:
      var k = easeLinear(d, b, c, e, f);
      break;
    case TYPE_IN_CUBIC:
      k = easeInCubic(d, b, c, e, f);
      break;
    case TYPE_OUT_CUBIC:
      k = easeOutCubic(d, b, c, e, f);
      break;
    case TYPE_IN_BACK:
      k = easeInBack(d, b, c, e, f);
      break;
    case TYPE_OUT_BACK:
      k = easeInBack(d, b, c, e, f)
  }
  return k
}
function easeOutBounce(a, d, b, c) {
  return (a /= c) < 1 / 2.75 ? 7.5625 * b * a * a + d : a < 2 / 2.75 ? b * (7.5625 * (a -= 1.5 / 2.75) * a + 0.75) + d : a < 2.5 / 2.75 ? b * (7.5625 * (a -= 2.25 / 2.75) * a + 0.9375) + d : b * (7.5625 * (a -= 2.625 / 2.75) * a + 0.984375) + d
}
function easeInBounce(a, d, b, c) {
  return b - easeOutBounce(c - a, 0, b, c) + d
}
function easeInOutBounce(a, d, b, c) {
  return a < c / 2 ? 0.5 * easeInBounce(2 * a, 0, b, c) + d : 0.5 * easeOutBounce(2 * a - c, 0, b, c) + 0.5 * b + d
}
function easeInCirc(a, d, b, c) {
  return - b * (Math.sqrt(1 - (a /= c) * a) - 1) + d
}
function easeOutCirc(a, d, b, c) {
  return b * Math.sqrt(1 - (a = a / c - 1) * a) + d
}
function easeInOutCirc(a, d, b, c) {
  return 1 > (a /= c / 2) ? - b / 2 * (Math.sqrt(1 - a * a) - 1) + d : b / 2 * (Math.sqrt(1 - (a -= 2) * a) + 1) + d
}
function easeInCubic(a, d, b, c, e) {
  return b * (a /= c) * a * a + d
}
function easeOutCubic(a, d, b, c, e) {
  return b * ((a = a / c - 1) * a * a + 1) + d
}
function easeInOutCubic(a, d, b, c, e) {
  return 1 > (a /= c / 2) ? b / 2 * a * a * a + d : b / 2 * ((a -= 2) * a * a + 2) + d
}
function easeInElastic(a, d, b, c, e, f, k) {
  if (0 == a) return d;
  if (1 == (a /= c)) return d + b;
  k || (k = 0.3 * c);
  !f || f < Math.abs(b) ? (f = b, e = k / 4)  : e = k / (2 * Math.PI) * Math.asin(b / f);
  return - (f * Math.pow(2, 10 * --a) * Math.sin(2 * (a * c - e) * Math.PI / k)) + d
}
function easeOutElastic(a, d, b, c, e, f, k) {
  if (0 == a) return d;
  if (1 == (a /= c)) return d + b;
  k || (k = 0.3 * c);
  !f || f < Math.abs(b) ? (f = b, e = k / 4)  : e = k / (2 * Math.PI) * Math.asin(b / f);
  return f * Math.pow(2, - 10 * a) * Math.sin(2 * (a * c - e) * Math.PI / k) + b + d
}
function easeInOutElastic(a, d, b, c, e, f, k) {
  if (0 == a) return d;
  if (1 == (a /= c)) return d + b;
  k || (k = 0.3 * c);
  !f || f < Math.abs(b) ? (f = b, e = k / 4)  : e = k / (2 * Math.PI) * Math.asin(b / f);
  return 1 > a ? - 0.5 * f * Math.pow(2, 10 * --a) * Math.sin(2 * (a * c - e) * Math.PI / k) + d : f * Math.pow(2, - 10 * --a) * Math.sin(2 * (a * c - e) * Math.PI / k) * 0.5 + b + d
}
function easeInExpo(a, d, b, c) {
  return 0 == a ? d : b * Math.pow(2, 10 * (a / c - 1)) + d
}
function easeOutExpo(a, d, b, c) {
  return a == c ? d + b : b * ( - Math.pow(2, - 10 * a / c) + 1) + d
}
function easeInOutExpo(a, d, b, c) {
  return 0 == a ? d : a == c ? d + b : 1 > (a /= c / 2) ? b / 2 * Math.pow(2, 10 * (a - 1)) + d : b / 2 * ( - Math.pow(2, - 10 * --a) + 2) + d
}
function easeLinear(a, d, b, c) {
  return b * a / c + d
}
function easeInQuad(a, d, b, c) {
  return b * (a /= c) * a + d
}
function easeOutQuad(a, d, b, c) {
  return - b * (a /= c) * (a - 2) + d
}
function easeInOutQuad(a, d, b, c) {
  return 1 > (a /= c / 2) ? b / 2 * a * a + d : - b / 2 * (--a * (a - 2) - 1) + d
}
function easeInQuart(a, d, b, c) {
  return b * (a /= c) * a * a * a + d
}
function easeOutQuart(a, d, b, c) {
  return - b * ((a = a / c - 1) * a * a * a - 1) + d
}
function easeInOutQuart(a, d, b, c) {
  return 1 > (a /= c / 2) ? b / 2 * a * a * a * a + d : - b / 2 * ((a -= 2) * a * a * a - 2) + d
}
function easeInQuint(a, d, b, c) {
  return b * (a /= c) * a * a * a * a + d
}
function easeOutQuint(a, d, b, c) {
  return b * ((a = a / c - 1) * a * a * a * a + 1) + d
}
function easeInOutQuint(a, d, b, c) {
  return 1 > (a /= c / 2) ? b / 2 * a * a * a * a * a + d : b / 2 * ((a -= 2) * a * a * a * a + 2) + d
}
function easeInSine(a, d, b, c) {
  return - b * Math.cos(a / c * (Math.PI / 2)) + b + d
}
function easeOutSine(a, d, b, c) {
  return b * Math.sin(a / c * (Math.PI / 2)) + d
}
function easeInOutSine(a, d, b, c) {
  return - b / 2 * (Math.cos(Math.PI * a / c) - 1) + d
}
function easeInBack(a, d, b, c) {
  return b * (a /= c) * a * (2.70158 * a - 1.70158) + d
}
function easeOutBack(a, d, b, c) {
  return b * ((a = a / c - 1) * a * (2.70158 * a + 1.70158) + 1) + d
}
function CCard(a, d, b) {
  var c,
  e,
  f = - 1,
  k,
  r,
  q,
  n,
  p,
  g,
  l,
  m,
  v,
  t;
  this._init = function (a, b, c) {
    t = c;
    c = {
      images: [
        s_oSpriteLibrary.getSprite('card_spritesheet')
      ],
      frames: {
        width: CARD_WIDTH,
        height: CARD_HEIGHT,
        regX: CARD_WIDTH / 2,
        regY: CARD_HEIGHT / 2
      },
      animations: {
        card_1_1: [
          0
        ],
        card_1_2: [
          1
        ],
        card_1_3: [
          2
        ],
        card_1_4: [
          3
        ],
        card_1_5: [
          4
        ],
        card_1_6: [
          5
        ],
        card_1_7: [
          6
        ],
        card_1_8: [
          7
        ],
        card_1_9: [
          8
        ],
        card_1_10: [
          9
        ],
        card_1_J: [
          10
        ],
        card_1_Q: [
          11
        ],
        card_1_K: [
          12
        ],
        card_2_1: [
          13
        ],
        card_2_2: [
          14
        ],
        card_2_3: [
          15
        ],
        card_2_4: [
          16
        ],
        card_2_5: [
          17
        ],
        card_2_6: [
          18
        ],
        card_2_7: [
          19
        ],
        card_2_8: [
          20
        ],
        card_2_9: [
          21
        ],
        card_2_10: [
          22
        ],
        card_2_J: [
          23
        ],
        card_2_Q: [
          24
        ],
        card_2_K: [
          25
        ],
        card_3_1: [
          26
        ],
        card_3_2: [
          27
        ],
        card_3_3: [
          28
        ],
        card_3_4: [
          29
        ],
        card_3_5: [
          30
        ],
        card_3_6: [
          31
        ],
        card_3_7: [
          32
        ],
        card_3_8: [
          33
        ],
        card_3_9: [
          34
        ],
        card_3_10: [
          35
        ],
        card_3_J: [
          36
        ],
        card_3_Q: [
          37
        ],
        card_3_K: [
          38
        ],
        card_4_1: [
          39
        ],
        card_4_2: [
          40
        ],
        card_4_3: [
          41
        ],
        card_4_4: [
          42
        ],
        card_4_5: [
          43
        ],
        card_4_6: [
          44
        ],
        card_4_7: [
          45
        ],
        card_4_8: [
          46
        ],
        card_4_9: [
          47
        ],
        card_4_10: [
          48
        ],
        card_4_J: [
          49
        ],
        card_4_Q: [
          50
        ],
        card_4_K: [
          51
        ],
        back: [
          52
        ]
      }
    };
    c = new createjs.SpriteSheet(c);
    v = createSprite(c, 'back', CARD_WIDTH / 2, CARD_HEIGHT / 2, CARD_WIDTH, CARD_HEIGHT);
    v.x = a;
    v.y = b;
    v.rotation = 120;
    v.stop();
    t.addChild(v);
    l = [
    ];
    m = [
    ]
  };
  this.unload = function () {
    g = p = null;
    t.removeChild(v)
  };
  this.addEventListener = function (a, b, c) {
    l[a] = b;
    m[a] = c
  };
  this.setInfo = function (a, b, d, l, m, t) {
    e = !1;
    n = 0;
    k = parseInt(d);
    r = l;
    p = a;
    g = b;
    q = t;
    c = m;
    f = STATE_CARD_DEALING
  };
  this.removeFromTable = function () {
    l[ON_CARD_TO_REMOVE] && l[ON_CARD_TO_REMOVE].call(m[ON_CARD_TO_REMOVE], this)
  };
  this.initRemoving = function (a) {
    p = new CVector2(v.x, v.y);
    g = a;
    n = 0;
    f = STATE_CARD_REMOVING
  };
  this.setValue = function () {
    v.gotoAndStop(k);
    var a = this;
    createjs.Tween.get(v).to({
      scaleX: 1
    }, 100).call(function () {
      a.cardShown()
    })
  };
  this.showCard = function () {
    var a = this;
    createjs.Tween.get(v).to({
      scaleX: 0.1
    }, 100).call(function () {
      a.setValue()
    })
  };
  this.hideCard = function () {
    var a = this;
    createjs.Tween.get(v).to({
      scaleX: 0.1
    }, 100).call(function () {
      a.setBack()
    })
  };
  this.setBack = function () {
    v.gotoAndStop('back');
    var a = this;
    createjs.Tween.get(v).to({
      scaleX: 1
    }, 100).call(function () {
      a.cardHidden()
    })
  };
  this.cardShown = function () {
    l[ON_CARD_SHOWN] && l[ON_CARD_SHOWN].call(m[ON_CARD_SHOWN])
  };
  this.cardHidden = function () {
    e = !0
  };
  this.getValue = function () {
    return r
  };
  this.getFotogram = function () {
    return k
  };
  this._updateDealing = function () {
    n += s_iTimeElaps;
    if (n > TIME_CARD_DEALING) f = - 1,
    n = 0,
    v.x = g.getX(),
    v.y = g.getY(),
    v.rotation = 360,
    l[ON_CARD_ANIMATION_ENDING] && l[ON_CARD_ANIMATION_ENDING].call(m[ON_CARD_ANIMATION_ENDING], this, c, q),
    this.showCard();
     else {
      this.visible = !0;
      var a = easeInOutCubic(n, 0, 1, TIME_CARD_DEALING),
      b = new CVector2;
      b = tweenVectors(p, g, a, b);
      v.x = b.getX();
      v.y = b.getY();
      v.rotation = 120 + 24000 * a / 100
    }
  };
  this._updateRemoving = function () {
    n += s_iTimeElaps;
    if (n > TIME_CARD_REMOVE) n = 0,
    e = v.visible = !1,
    f = - 1,
    l[ON_CARD_TO_REMOVE] && l[ON_CARD_TO_REMOVE].call(m[ON_CARD_TO_REMOVE], this);
     else {
      var a = easeInOutCubic(n, 0, 1, TIME_CARD_REMOVE),
      b = new CVector2;
      b = tweenVectors(p, g, a, b);
      v.x = b.getX();
      v.y = b.getY();
      v.rotation = 4500 * a / 100
    }
  };
  this.update = function () {
    switch (f) {
      case STATE_CARD_DEALING:
        this._updateDealing();
        break;
      case STATE_CARD_REMOVING:
        !0 === e && this._updateRemoving()
    }
  };
  s_oCard = this;
  this._init(a, d, b)
}
var s_oCard;
function CGameOver() {
  var a,
  d,
  b,
  c;
  this._init = function () {
    c = new createjs.Container;
    s_oStage.addChild(c);
    c.on('click', function () {
    });
    var e = createBitmap(s_oSpriteLibrary.getSprite('msg_box'));
    c.addChild(e);
    a = new createjs.Text(TEXT_NO_MONEY, '32px ' + FONT_GAME_1, '#fff');
    a.textAlign = 'center';
    a.x = CANVAS_WIDTH / 2;
    a.y = 290;
    a.lineWidth = 300;
    a.shadow = new createjs.Shadow('#000000', 2, 2, 2);
    c.addChild(a);
    d = new CTextButton(CANVAS_WIDTH / 2 - 100, 450, s_oSpriteLibrary.getSprite('but_game_bg'), TEXT_RECHARGE, FONT_GAME_1, '#fff', 14, c);
    d.addEventListener(ON_MOUSE_UP, this._onRecharge, this);
    b = new CTextButton(CANVAS_WIDTH / 2 + 100, 450, s_oSpriteLibrary.getSprite('but_game_bg'), TEXT_EXIT, FONT_GAME_1, '#fff', 14, c);
    b.addEventListener(ON_MOUSE_UP, this._onExit, this);
    this.hide()
  };
  this.unload = function () {
    d.unload();
    b.unload();
    c.off('click', function () {
    })
  };
  this.show = function () {
    c.visible = !0
  };
  this.hide = function () {
    c.visible = !1
  };
  this._onRecharge = function () {
    $(s_oMain).trigger('recharge')
  };
  this._onExit = function () {
    s_oGame.onExit()
  };
  this._init()
}
function CWinDisplay(a, d, b) {
  var c,
  e,
  f,
  k;
  this._init = function (a, b) {
    c = a;
    k = new createjs.Container;
    k.visible = !1;
    k.x = a;
    k.y = b;
    r.addChild(k);
    var d = s_oSpriteLibrary.getSprite('win_bg'),
    g = createBitmap(d);
    k.addChild(g);
    e = new createjs.Text('', '23px ' + FONT_GAME_1, '#fff');
    e.x = d.width / 2;
    e.y = d.height / 2 - 20;
    e.textAlign = 'center';
    e.textBaseline = 'middle';
    k.addChild(e);
    f = new createjs.Text('', '29px ' + FONT_GAME_1, '#fff');
    f.x = d.width / 2;
    f.y = d.height / 2 + 22;
    f.textAlign = 'center';
    f.textBaseline = 'middle';
    k.addChild(f)
  };
  this.show = function (a, b) {
    e.text = a;
    0 < b ? (f.color = '#07a74f', f.text = TEXT_WIN + ' ' + b.toFixed(2))  : (f.color = '#ce0909', f.text = TEXT_NO_WIN);
    k.visible = !0;
    createjs.Tween.get(k).to({
      x: CANVAS_WIDTH / 2 + 100
    }, 400, createjs.Ease.cubicOut)
  };
  this.hide = function () {
    createjs.Tween.get(k).to({
      x: c
    }, 400, createjs.Ease.cubicOut).call(function () {
      k.visible = !1
    })
  };
  var r = b;
  this._init(a, d)
}
function CHistory(a, d, b) {
  var c,
  e,
  f,
  k,
  r,
  q,
  n,
  p,
  g,
  l,
  m;
  this._init = function (a, b) {
    p = s_oSpriteLibrary.getSprite('history_cell');
    l = new createjs.Container;
    l.x = a;
    l.y = b;
    v.addChild(l);
    q = createBitmap(s_oSpriteLibrary.getSprite('history_bg'));
    q.alpha = 0;
    l.addChild(q);
    m = new createjs.Container;
    m.x = 5;
    m.y = 5;
    l.addChild(m);
    k = 7 * p.height;
    g = new createjs.Shape;
    g.graphics.beginFill('rgba(255,0,0,0.01)').drawRect(m.x, m.y, p.width, k);
    l.addChild(g);
    m.mask = g;
    n = createBitmap(s_oSpriteLibrary.getSprite('history_highlight'));
    n.alpha = 0;
    n.x = 5;
    n.y = 5;
    l.addChild(n);
    r = [
    ]
  };
  this.addHistoryRow = function (a, b, d) {
    c = a;
    e = b;
    f = d;
    if (0 < r.length) for (a = 0; a < r.length; a++) r[a].moveDown(this);
     else createjs.Tween.get(q).to({
      alpha: 1
    }, 400, createjs.Ease.cubicOut),
    createjs.Tween.get(n).to({
      alpha: 1
    }, 400, createjs.Ease.cubicOut),
    a = new CHistoryRow(0, 0, c, e, f, p, m),
    r.push(a)
  };
  this._showNextRow = function (a) {
    a === r[0] && (0 < r.length && r[0].getY() >= k && (r[0].unload(), r.splice(0, 1)), a = new CHistoryRow(0, 0, c, e, f, p, m), r.push(a))
  };
  this.setPosition = function (a, b) {
    l.x = a;
    l.y = b
  };
  var v = b;
  this._init(a, d)
}
function CHistoryRow(a, d, b, c, e, f, k) {
  var r,
  q;
  this._init = function (a, b, c, d, f) {
    r = f.height;
    q = new createjs.Container;
    q.alpha = 0;
    q.x = a;
    q.y = b;
    p.addChild(q);
    b = new createjs.SpriteSheet({
      images: [
        f
      ],
      frames: {
        width: f.width / 2,
        height: f.height
      },
      animations: {
        state_lose: [
          0
        ],
        state_win: [
          1
        ]
      }
    });
    a = [
    ];
    a[0] = createSprite(b, 'state_lose', 0, 0, f.width / 2, f.height);
    q.addChild(a[0]);
    a[1] = createSprite(b, 'state_lose', 0, 0, f.width / 2, f.height);
    a[1].x = f.width / 2;
    q.addChild(a[1]);
    0 < e && a[e - 1].gotoAndStop('state_win');
    c = new createjs.Text(c, '24px ' +
    FONT_GAME_1, '#fff');
    c.x = a[0].x + f.width / 4;
    c.y = a[0].y + f.height / 2;
    c.textAlign = 'center';
    c.textBaseline = 'middle';
    q.addChild(c);
    d = new createjs.Text(d, '24px ' + FONT_GAME_1, '#fff');
    d.x = a[1].x + f.width / 4;
    d.y = a[1].y + f.height / 2;
    d.textAlign = 'center';
    d.textBaseline = 'middle';
    q.addChild(d);
    createjs.Tween.get(q).to({
      alpha: 1
    }, 400, createjs.Ease.cubicOut)
  };
  this.unload = function () {
    p.removeChild(q)
  };
  this.moveDown = function (a) {
    var b = q.y + r;
    createjs.Tween.get(q).to({
      y: b
    }, 400, createjs.Ease.cubicOut).call(function () {
      a._showNextRow(n)
    })
  };
  this.getY = function () {
    return q.y
  };
  var n = this;
  var p = k;
  this._init(a, d, b, c, f)
}
function CMsgBox() {
  var a,
  d,
  b,
  c;
  this._init = function () {
    a = createBitmap(s_oSpriteLibrary.getSprite('msg_box'));
    b = new createjs.Text('', '34px ' + FONT_GAME_1, '#000');
    b.x = CANVAS_WIDTH / 2 + 2;
    b.y = CANVAS_HEIGHT / 2 - 28;
    b.textAlign = 'center';
    b.lineWidth = 400;
    b.textBaseline = 'middle';
    d = new createjs.Text('', '34px ' + FONT_GAME_1, '#ffffff');
    d.x = CANVAS_WIDTH / 2;
    d.y = CANVAS_HEIGHT / 2 - 30;
    d.textAlign = 'center';
    d.lineWidth = 400;
    d.textBaseline = 'middle';
    c = new createjs.Container;
    c.alpha = 0;
    c.visible = !1;
    c.addChild(a, b, d);
    s_oStage.addChild(c)
  };
  this.unload = function () {
    c.off('mousedown', this._onExit)
  };
  this._initListener = function () {
    c.on('mousedown', this._onExit)
  };
  this.show = function (a) {
    b.text = a;
    d.text = a;
    c.visible = !0;
    var e = this;
    createjs.Tween.get(c).to({
      alpha: 1
    }, 500).call(function () {
      e._initListener()
    });
    setTimeout(function () {
      e._onExit()
    }, 3000)
  };
  this._onExit = function () {
    c.visible && (c.off('mousedown'), c.visible = !1)
  };
  this._init();
  return this
}
function CCreditsPanel() {
  var a,
  d,
  b,
  c,
  e,
  f,
  k,
  r,
  q;
  this._init = function () {
    q = new createjs.Container;
    s_oStage.addChild(q);
    var n = createBitmap(s_oSpriteLibrary.getSprite('bg_menu'));
    q.addChild(n);
    f = new createjs.Shape;
    f.graphics.beginFill('rgba(0,0,0,0.7)').drawRect(0, 0, CANVAS_WIDTH, CANVAS_HEIGHT);
    q.addChild(f);
	
    n = s_oSpriteLibrary.getSprite('msg_box');
    b = createBitmap(n);
    b.x = CANVAS_WIDTH / 2;
    b.y = CANVAS_HEIGHT / 2;
    b.regX = n.width / 2;
    b.regY = n.height / 2;
    q.addChild(b);
    k = new createjs.Shape;
    k.graphics.beginFill('#0f0f0f').drawRect(0, 0, CANVAS_WIDTH, CANVAS_HEIGHT);
    k.alpha = 0.01;
    d = k.on('click', this._onLogoButRelease);
    q.addChild(k);
    n = s_oSpriteLibrary.getSprite('but_exit');
    a = CANVAS_WIDTH / 2 - 234;
    c = new CGfxButton(a, 270, n, q);
    c.addEventListener(ON_MOUSE_UP, this.unload, this);
    e = new createjs.Text(TEXT_CREDITS_DEVELOPED, '26px ' + FONT_GAME_1, '#ffffff');
    e.x = CANVAS_WIDTH / 2;
    e.y = 310;
    e.textAlign = 'center';
    q.addChild(e);
    n = s_oSpriteLibrary.getSprite('logo_credits');
    var p = createBitmap(n);
    p.regX = n.width / 2;
    p.regY = n.height / 2;
    p.x = CANVAS_WIDTH / 2;
    p.y = CANVAS_HEIGHT / 2;
    q.addChild(p);
    r = new createjs.Text('www.codethislab.com', '24px ' + FONT_GAME_1, '#ffffff');
    r.x = CANVAS_WIDTH / 2;
    r.y = 420;
    r.textAlign = 'center';
    q.addChild(r)
  };
  this.unload = function () {
    k.off('click', d);
    c.unload();
    c = null;
    s_oStage.removeChild(q)
  };
  this._onLogoButRelease = function () {
    window.open('http://www.codethislab.com/index.php?&l=en')
  };
  this._init()
}
function extractHostname(a) {
  a = - 1 < a.indexOf('://') ? a.split('/') [2] : a.split('/') [0];
  a = a.split(':') [0];
  return a = a.split('?') [0]
}
function extractRootDomain(a) {
  a = extractHostname(a);
  var d = a.split('.'),
  b = d.length;
  2 < b && (a = d[b - 2] + '.' + d[b - 1]);
  return a
}
var getClosestTop = function () {
  var a = window,
  d = !1;
  try {
    for (; a.parent.document !== a.document; ) if (a.parent.document) a = a.parent;
     else {
      d = !0;
      break
    }
  } catch (b) {
    d = !0
  }
  return {
    topFrame: a,
    err: d
  }
},
getBestPageUrl = function (a) {
  var d = a.topFrame,
  b = '';
  if (a.err) try {
    try {
      b = window.top.location.href
    } catch (e) {
      var c = window.location.ancestorOrigins;
      b = c[c.length - 1]
    }
  } catch (e) {
    b = d.document.referrer
  } else b = d.location.href;
  return b
},
TOPFRAMEOBJ = getClosestTop(),
PAGE_URL = getBestPageUrl(TOPFRAMEOBJ);
function seekAndDestroy() {

  return !0
};
