/*
Copyright 2015, 2019 Google Inc. All Rights Reserved.
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 http://www.apache.org/licenses/LICENSE-2.0
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
*/

// Incrementing OFFLINE_VERSION will kick off the install event and force
// previously cached resources to be updated from the network.
const OFFLINE_VERSION = 1;



self.addEventListener('install', (event) => {
  event.waitUntil((async () => {
   console.log("SW installed");
  })());
});

self.addEventListener('activate', (event) => {
  event.waitUntil((async () => {
    // Enable navigation preload if it's supported.
    // See https://developers.google.com/web/updates/2017/02/navigation-preload
    if ('navigationPreload' in self.registration) {
      await self.registration.navigationPreload.enable();
    }
  })());

  // Tell the active service worker to take control of the page immediately.
  self.clients.claim();
});

self.addEventListener('fetch', (event) => {
  // We only want to call event.respondWith() if this is a navigation request
  // for an HTML page.
  if (event.request.mode === 'navigate') {
    event.respondWith((async () => {
      try {
        // First, try to use the navigation preload response if it's supported.
        const preloadResponse = await event.preloadResponse;
        if (preloadResponse) {
          return preloadResponse;
        }

        const networkResponse = await fetch(event.request);
        return networkResponse;
      } catch (error) {
        // catch is only triggered if an exception is thrown, which is likely
        // due to a network error.
        // If fetch() returns a valid HTTP response with a response code in
        // the 4xx or 5xx range, the catch() will NOT be called.
        console.log('Fetch failed; returning offline page instead.', error);

        
		  return new Response("<style>*{font-family:Verdana, Arial;color:gray;text-align:center} img{max-width:80%}</style><br/><br/><br/><br/><br/><br/><br/><br/><p align='center'><h1>An internet connection is needed</h1></p><p align='center'><img src='data:image/gif;base64,iVBORw0KGgoAAAANSUhEUgAAAzIAAAKnAQMAAABnJ+oqAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAGUExURescPf/+/hAXL7QAAAAJcEhZcwAADsMAAA7DAcdvqGQAAA8ASURBVHja7d29kiQ5EQBg9VZMtHFG4xBjto+zj9Bt4OABDub4YPAIrWfgBVjzGAePMzC2eIM18KkIDCaIIKKMJVDM1UrszPR0K1NKKVOlqgsGybrbmamvU0qp/iS1cquUvjnNaU5zmtOc5jSnOc1pTnOa05zmNKc5zWlOc5rTnOY0pznNaU5zmtOc5jSnOc1pTnOa05xY+fVRKXXzq4Wdv6pz2dwt6NgP6lp+vJhjtfLLN0s5RwXLdhkHM0rdLuF8UmG5q+8YFSvVHZQDr6Wr7XxS8fK+rvNIMOpdXUdTDjfneM5nklGbU0XnSDtqV88xKlVO1Zxj0vmmljMpNTsgjvMh49zWcXLhsEYfhtNnnd/XcL4cs85NDWdU+XKq4GiGs53vPDIYtZnvDBxH7Wc7LCafCTnH8JxsJuScnum8n+d8YTLZiss4I9dR85xPbGc3x7FsJldxacfwnUzGpZ1e4OxnOAImc2madCTVlsm4pDOInH2xI2LSJ4eU8yhzVKkzCJ1TofNB6OzKHCtkkpmdcIzUSVVcwunFzmElZ1viTGImddlDOw9yJ1FxtNOv41hd4HRyp6B5ipyS5klUHOn0Rc57saOLnE7qFDVPgWPKHHKIo5y+0NkLHV3obGVOYfPQQ1xth2ogwhmKnYPI0cXOTuLYYobqQXGnvHmUkjjDDOduJWcncNQ6TioNNj/5m/vyy9Qv8J3EIPrH8698G/3pu4/uyy9ObIe8m/ceVj9Gulji4XzUoQbrG/+jfkl9Cp5DMOjjBrdHqWcvMYfqpR/R76HqTd4IxxzibUJ4CvuU+XnGiffSyBkMXEumnynGnGgaRBvZj3wndqLh3BJ/fini5y7R0YColevvZt7URZzoaEBd0F5SYS92YqMB+dTrEtBHsaMF4VySM/cEm+ckjnIO6FbsxNJgnzxCOmDKiY06qSO8/L78+XUkDdJd8Kmes++fQycy6qQ/rGE0T8QJ0yDzKNcymifiyLLgqQyMF02BE6ZB9uXOxJgeEDjhqJN/WaULnDANsnXvhn0FJ/9OzNmD3AnC4b2Pn+8cFnFMQbVVcXbLOEEanNZxNgs5OJytW8fZL+MEo5tbxsHp1i3kDAtVW845LOSgk6l0MHjUP/sty5mX1c93eJznFNOs5nm5HeLc1+N0kw0G5yuy27wzzsnqy4Vs3hnmOJcn+Luso+c0j059vKQjYrzr/0PGQbcKst7j1fltxkFpLes9x+QHBI6Z0TygLj6mHZRuot5j0p8QOP2M5unTNZ5wZM0DUzXtzGiecwrd3xMN5DsorUXnHvPaoi+D6T7loLSWMC8pdLiI25QD01o2uHk3w30sh3wHprXogtd6FW1ilUE74l56iUFHGtd3YGqKeunTievW/58915EPopcQbCQRPAemtbiXenlzDLPIc2Ba30odb3r0GCaC58C0FvXSCf7B56QzlqfBhG6Uws/pOUN5GoyoQXTQ/TynL0+DAR13DA7gOaDaZLe/PaonEyQc5chuFBQ6E9ig4q/OVJ4G4WGDhCMcWRrYSDWhGrk6IK1lJwUTtOfIdGRpMAbjZiBfHZDWsivr8MGlZTqyG59eRZ6ydoQD0k3EfO3+XfhPG4YjfGwQ+YMBfdaLA9JaNurYSN7wHFm6TZG8MSixLw44m8pGHRPJm4lyXHm6xRyHKuXq6NJR52tbRP6AdPridBtif9DDZLo6Q2m64UO+/mMXd8bSUedrjUfyc4SVeXVMabq56Acjnak03ezlgz3e39//4e5yuFPUsaXpdj3i6PVx0nEzHBc6Dla/5+jCdDOXDzb6SQRbLXb9tit1jO/ALIxdjwrTbbhUAIinp+IZy9LNc4xfGwOo/9j9goz5eojXQ4N4RsqZytLNqyDQPgYMPJH7OekrEn1pUORs4o4rdFTcmZQiHF00itpr4gDHkk7PS+s/3X+HHBdzHEjcyHOKtPLz59/x9o2Yru1gwMcknTHvXGY6vSOdSzzar5nwOVLqpO3Nebu5/lUXd3rKmXLpBuZtdYRzuB56H3dsbhSFC3XO0+rG619AZ6Acl0lrNC/u/MTAcybw96P/kYHzXC30KKpQ2Z4/NhEPGODC572kE064uXtx9iCew1WlnKcORI6ikXlK3csRDvF4aGdMObGlmyfowHjA9JTg/QKV1tF1LU8/0Neaho71P3PwvoRK6+h6k0LnqQmotFaUo9CZ8joIkE7kuRk4BC6bjKMoRyfWBRCOXzvTa268Ho1yemq0js/IfnE6Kh6v5YL3msRoHV911MUc/9iUM1LOkXSmlHMgHEOkNTGD+cXZyp2JcEba8UcXC9tnIB1LpDWxDGTrYBWgePwTEJ5/EHWoid/YsdAZaUdHw3lIOP7B+E4fdfoyxw8VOX+PMeSyiR1yJrbzfcwxKcdPKhSPn/I9426nX8nR6zj0oqO9g4PYs+NKnVHm+P/bSRydcRwVj8yxfMfBeJzISSwG2jt40kTxyJwHvuOwsxE4iSV7TxmtN4l4FnJwPFrgpBa8HuBn/uEcxXf6nNPVcdQMp+c7yRWVJ9jn58TzeaV4hmw8W+jAh1QnrqPn1BvfSS+srReP0NHQGdjOmHOmVDx8ZxDHo4ocLYunuN7UTOfAczLrqx2+k1GFzsiIZ0fHM3KdYZ7Dbp9+pXjSTNg+hU5uOX+teEw+HoOdrsAZV6q3vqDeSuLR0nj6Iie7q4Or0z5Z51QnHrNSPMNK8fSMeGo4VLr9qG488TR43gPhnxfHLOS8zhI91osnlm6Xt1hWE+2zFTuR0c3b0eGxWjyRdPPXEA1xZwt+pcwBOxxbnXV48YThwFn8Y514wnTDr2x04AwF7TNlwvmakPl4GNc7JheOc8H16FBQb0Mq2S4l4zDiwekWf3FnZzt4FI2/6JrQLBC5g6st/gJqdjw2mwV5h3N/itP6lnK6eQ4eRR3loHiIyU5c54Z0ZsbTc7It4kjjQQ653Qka0KjJTqQDGXouVCoeLXboyRzoBkHqoLQ+8Bwcz0boJFbZ61Q8eQemdWJOT8phPL9mrwkDz+PlTs9snrTTCR2acf08RzObJxWPlcaTWqvlv88qcAZm8wSONxBy3s+BvE5NKPXfN6J4OI5/VZWc6IkdYTz+eLBlO0bs+JcHe7YD40m8374WZhqA9+ho2Q/L0axeihwYT2L+gfN+wOml6EbYyJ2BlwYpZ+A4Iy8N4Gw67BzyjmH1UnSBXeBMbKejnJ7jWNZoEDpgDuwp7zheGsBZe1/+7LwLPc1yXjvQLud09BEcw+k5o4FDF1bwJyxnYKUBPBoolueMnFHHwVZAn2DDcQxn1Ek5lpynCsrESjfYS9ABWPFYzqiTcgwvHsd0BupX6HnEsGhWutHOyHR6VrrBaePkDxLOwEo32qHnx+MDsBy/GcD1G9cxjNHNwbQC93Pk+gVUJla6gW4C4tFMx7LSDTvXD0auL8GF5/jDJYiH7Wjepobe8fx46PU/uPS8lahgKQFYzMB0Bt4aKg0c7783TGfkLQ301sX48ZDrzYJieEsDoRNfXpJ0Jp7jLfybwLIcrmN5SwOh4z3Z2zEdx3O8FboTWM7EdjRrgbUBziUecv1pWHrW0kCvo1jgHLjOsGM6p+R/Zp2RtQTxut7Z2Z/+zhU4hreyVrZ+O1Im3spa2Xr0SLGO6UjW15cXYr+ABRzJ/gflRbafQ12H3p+ivIj225hRbMQZUYw1HBc5v5P7lMwpov1dZpTIMjVN7ldT1ZlwVVZxwv2EJnqfnxnFBE4gFzjf/wbvNTtJ9ntilueJLuhFQLivlKb3r2KWY+ypAl5/adVc5yH6dElL9hfjFOLpn2i/NE7p409nRfu/MYr3NgAEZFB76NR+dozivxU6IB++zsBnJJnjMbAB4BOAB5XaBzBf4FQb/ydwYqJO7p+YL/Cl6nv0k8uT3sx+kNmCpoz4Ux/A/pYPKr2/Za7gtSZeU09+Bj4NGXczHDxDyTuW9f7/Uan0/qO5gphg5cK57Z92l3g3wwkmkKGZB+eAHpXK7A+bKeFCOtQ1n6cpvCwf3M1wwnmEXma/fMnVu+/+dcQpInYCBnRGyX7EyRJZm+G39gcqQ6RObJ0jfEV7LbsZTp92QLinGU5sywDcg84lt593qkRnFaO5SHS18Z34Ep34LxxmOPFJ7P4RdaLa5jp+DY2JauM7KusI9vcXO6CKzgFt5zgTwzl//8JpjkMtnQGp9XzClXzvZVgGjuP+rTZxhu1Qaxm4e99xHYJhb3rGdMilM5u6jvmhHe5mfkyHXqJzqOrQS3R2VR2S4SbcbKer6STWoW5WclRNJ7UA8VTRSa0821d0+pWc1ELHbUVHreMkFzpu6jnJZdzd/56TrLddPcet5aTyeq1+uta4U9NJjaOuopNYKbzW+afqeduu5CQ6UN3rHboDrXX9VtehO1Dd6166A7mqzlr3C2QHWu4+6wZsS1zZcbDhr0+ya9+fXjrQLfzfQ2Wnh/k1LeUMqD38WqzpjOjzc2dnSx2Dusu54rraTjAbWy/jWNzsg6j7SJ+/+ZtkSroP39GomqworflOj6tJL+MM+LCDpPvwnRE7RtJ9+I5R6GTzqCRfoSB6Hg97iyStZe8XYBbrRZynjw9vQQbJN4PwnWBv7FHyzSCi90zwH6ZlnGB24CT5BhK+E+6NLfkGEr4T7o2tuyWccG/sfhEn3Bt73C7huKDVzW4RJ9gb2+wXcf6C/8GeFnH+EThuEec/bkapMp+vOc1pTnOa05zmNKc5zWlOc5rTnOY0pzk1nMf7dZxjcp/Das4k/wboIueTEn9Dd5Gjlfgbx0ucSfQ6c6ajlneGVZ394o5eyVGy982ljvQ9/Uxns7RjhPMbSp1ROF+j1BlWdvYLO3plZ7ewo1Z2tss6dm2nW9aZ1nY2yzpmbUe9DWdc3Tm9CWdozkzn0BzRr7d6K3FavZU5b7fe3tr49jbOC+ObddyijnmrzsLX8dNbdRa+n7NrOwvfb6/2nGKt5y6vJ+79Ss5hYWdY2Vn6eeJaz2FN2bAjduy6zuLP/c8ddbeSs/z7kqEoreWOKUrrwvdzm+UdV5QGBc5QkgYFzkNJ85S8Ry/opUXO5+evFF/eKSrNaU5zmtOc5jSnOc1pTnOa05zmNKc5zWnO/6Hj+v8CxqEh4H/KhZgAAAAASUVORK5CYII='/></p>", {
			headers: {'Content-Type': 'text/html'}
		  })
		   
      }
    })());
  }

  // If our if() condition is false, then this fetch handler won't intercept the
  // request. If there are any other fetch handlers registered, they will get a
  // chance to call event.respondWith(). If no fetch handlers call
  // event.respondWith(), the request will be handled by the browser as if there
  // were no service worker involvement.
});